# Generated by LaTeX DogWagger Version 4.0.5 from file <NCTLL_904.tex>
# Date: [2020-9-17 13:16:5] 
# Do NOT edit this file. Edit the LaTeX source!!

# - <Section 16> - 
#' Allometric scaling of metabolic rates
#' 
#' Log-log plot of mammalian weights (grams) against metabolic rates. The PDF file is allometry.pdf.
#' 
#' @param pdf will not print to PDF
#' @param base base for logarithms, default 10 
#' @keywords corona allometric scaling exponent Kleiber allometry two thirds three quarters
#' @export 
#' @import ggplot2 
#' @importFrom stats lm
#' @importFrom gridExtra tableGrob 
#' @examples
#' corona_metabolism ( ) 

corona_metabolism <- function ( pdf=FALSE, base=10 )
{ ALMY <- allo;
  ALMY$LogMass <- log(ALMY$Mass, base=base);
  ALMY$LogMR <- log(ALMY$MR, base=base);
  PdfFilename <- 'allometry.pdf'; 

# - <Section 17> - 
  MassFRQ <- corona_benford(ALMY$Mass); 
  MetFRQ <- corona_benford(ALMY$MR); 
  MassTBL <- gridExtra::tableGrob(MassFRQ[,1:2]);
  MetTBL <- gridExtra::tableGrob(MetFRQ[,1:2]); 
  mTop <- max(ALMY$LogMR);
  mRight <- max(ALMY$LogMass); 

  corona_pdf(PdfFilename, 8, 8, pdf); 
  myplot <- ggplot( ALMY, aes(x=.data$LogMass, y=.data$LogMR) ) + 
    geom_point() + 
    geom_smooth(method='lm', colour='red', linetype='solid') + 
    labs(title='Mammalian Allometry', x='Log(mass)', y='Log(metabolic rate)'); 

  myplot <- corona_annotate( myplot, MetTBL[,2:3], top=mTop, right=mRight, xmin=0.08, 
                             xmax=0.4, ymin=0.58, ymax=0.99);  
  myplot <- corona_annotate( myplot, MassTBL[,2:3], top=mTop, right=mRight, xmin=0.8, 
                             xmax=0.99, ymin=0.05, ymax=0.7);  

  corona_print(myplot); 
  corona_pdf_off(PdfFilename, pdf); 
}
# -END OF FILE- 
