# Generated by LaTeX DogWagger Version 4.0.5 from file <NCTLL_904.tex>
# Date: [2020-9-17 13:16:5] 
# Do NOT edit this file. Edit the LaTeX source!!

# - <Section 18> - 
#' Plot citymapper data against COVID-19 diagnoses, over time 
#'
#' Requires ggplot2, plyr and the data frames lock, owid, citymap.  
#'    Multiple, select frames are plotted. 
#' 
#' @param pdf = TRUE writes to PDF, default FALSE
#' @param cols Number of columns in output, default is 4 
#' @param FewCities a c() list of city names from the city options. Default is all. 
#' @keywords corona countries daily rates citymapper citymap 
#' @export 
#' @import ggplot2 
#' @importFrom plyr ddply
#' @importFrom stats loess
#' @importFrom stats aggregate
#' @importFrom stats na.pass
#' @importFrom graphics frame 
#' @examples
#' corona_citymap(cols=4); 
#' 

corona_citymap <- function ( pdf=FALSE, FewCities=NULL, cols=4 ) 
{ OW <- owid; 
  citymaxdate <- max(citymap$Date); 
  OW <- OW[ OW$date <= citymaxdate, ];  # if don't limit and max is later, curve is squashed
  OW$location <- cntry[ match(OW$iso_code, cntry$iso_code), c('location')]; # map in country name
  OW <- OW[order(OW$location),];
if( is.null(FewCities) )
  { 
  FewCities <- c('Australia', 'Brazil', 'Canada', 'Denmark',
               'France', 'Germany', 'Japan', 'Mexico', 
               'Russia', 'Singapore', 'South Korea', 'Spain', 
               'Sweden', 'Turkey', 'United Kingdom', 'United States'); 
  }; 

# - <Section 19> - 
   smfx <- function ( x )
    { FOO <- loess(x$new_cases ~ as.numeric(x$date), span=0.2); # don't use a value < 0.1 
      smoother <- FOO$fitted; 
      data.frame(smoother); 
    }; 
  OW <- OW[ !(is.na(OW$new_cases)) , ];
  ## SMOO <- ddply(OW, .(location), smfx );  # fails devtools check
   SMOO <- ddply(OW, c('location'), smfx ); 
  OW$smoothed <-SMOO$smoother; 

# - <Section 20> - 
  maxcases <- aggregate(OW$smoothed, by=list(OW$location), max); 
  names(maxcases)[1] <- 'location'; 
  names(maxcases)[2] <- 'max_rate';
  OW$max <- maxcases[match(OW$location, maxcases$location),2]
  OW$scaled <- 100.0 * OW$smoothed / OW$max; 

# - <Section 21> - 
  TopNames <- mapply(gsub, pattern = '[.]', replacement = ' ', names(citymap)); 
  OW <- OW[ OW$location %in% TopNames, ] ;
  OW$lock <- lock[match(OW$iso_code, lock$iso_code), c('Lockdown')];

# - <Section 22> - 
  cityfx <- function ( x )
  { colnam <- gsub( pattern=' ', replacement='.', x[1, 'location']); 
    print(paste('Location is', colnam)); 
    foo <- 100 * citymap[ citymap$Date %in% x$date, colnam];
    bar <- x[ x$date %in% citymap$Date, ]; 
    data.frame( traffic = foo, date = bar$date, scaled = bar$scaled, lock = bar$lock ); 
  };
  CITYUSE <- ddply(OW, c('location'), cityfx); # .(location) fails devtools check
  CITYUSE <- CITYUSE[ CITYUSE$location %in% FewCities, ];
  OW <- OW[ OW$location %in% FewCities, ]; 
  LOCKED = 'red';
  TRAFFIC = 'blue'; 
  bas = c(LOCKED, TRAFFIC); 
  citymain <- "New Cases v Traffic Data"; 

# - <Section 23> - 
  PdfFilename <- 'citymapper.pdf';
  corona_pdf(PdfFilename, 10, 7, pdf); 
  plotall <- ggplot(CITYUSE, aes(x=date, y=.data$scaled)) + 
       scale_color_identity(guide = 'legend', name=' ', 
               breaks=bas, labels=c( 'lockdown', 'traffic')) + 
       geom_line() + 
       labs(title=citymain, x='Date', y='Cases/Maximum cases') + 
       coord_cartesian( ylim = c(0, 100)) + 
       facet_wrap(vars(.data$location), ncol=cols) + 
      geom_vline( data=OW, aes(xintercept=lock, colour=LOCKED) ) + 
      geom_line( data=CITYUSE, aes(x=date, y=.data$traffic, colour=TRAFFIC) ) + 

    theme( plot.title=element_text(size=18, face="bold"), 
           axis.text.x=element_text(size=10), 
           axis.text.y=element_text(size=10),
           axis.title.x=element_text(size=14),
           axis.title.y=element_text(size=14),
           strip.text = element_text(size = 12),
           strip.text.x = element_text(margin = margin(0,0,0.2,0, "mm"))
         );  # Note use of strip.text.x ; cf corona_print(myplot); 
  print(plotall); 
  corona_pdf_off(PdfFilename, pdf); 
}
# -END OF FILE- 
