# Generated by LaTeX DogWagger Version 4.0.5 from file <NCTLL_904.tex>
# Date: [2020-9-17 13:16:5] 
# Do NOT edit this file. Edit the LaTeX source!!

# - <Section 1> - 
#' Demonstrate (graph) exponential growth of rabbit population:
#' 
#' For finer details, see the LyX/PDF documentation. 
#' @param topyear is last year, defaults to 6
#' @param pdf Will not print to PDF if FALSE (the default)
#' @keywords corona rabbits
#' @export 
#' @import ggplot2 
#' @importFrom graphics frame 
#' @importFrom gridExtra tableGrob 
#' @examples
#' corona_rabbits( topyear=10) 

corona_rabbits <- function ( topyear = 6, pdf = FALSE ) 
{ 
if( topyear > 14 )
  { stop( paste('Too many rabbits, years =', topyear) ); 
  };
  years <- seq(from=0, to=topyear); 
  RABBITS <- data.frame(years);
  RABBITS$rabbits <- as.integer(24 * 3.5^RABBITS$years); 
  INTABLE <- gridExtra::tableGrob(RABBITS[,1:2]); 
  TopRabbits <- max(RABBITS$rabbits); 
  PdfFilename <- 'exponential_rabbits.pdf'; 
  corona_pdf(PdfFilename, 5, 5, pdf); 
  myplot <- ggplot( RABBITS, aes(x=years, y=.data$rabbits) ) + 
    geom_point() + geom_line() + 
    labs( title='Count the rabbits', x='Year', y='Rabbits' ) + ylim(0,TopRabbits) + 
    annotation_custom( INTABLE[,2:3], xmin=0.3, xmax=topyear/3.5, 
                       ymin=0.3*TopRabbits, ymax=0.9*TopRabbits ); 
  corona_print(myplot); 
  corona_pdf_off(PdfFilename, pdf); 
}
# -END OF FILE- 
