% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_generation.R
\name{data_generation}
\alias{data_generation}
\title{The function data_generation generates an example dataset for applying the cossonet function.}
\usage{
data_generation(
  n,
  p,
  rho,
  SNR,
  response = c("continuous", "binary", "count", "survival")
)
}
\arguments{
\item{n}{observation size.}

\item{p}{dimension.}

\item{rho}{a positive integer indicating the correlation strength for the first four informative variables.}

\item{SNR}{signal-to-noise ratio.}

\item{response}{the type of the response variable.}
}
\value{
a list of explanatory variables, response variables, and true functions.
}
\description{
The function data_generation generates an example dataset for applying the cossonet function.
}
\examples{
# Generate example data
set.seed(20250101)
tr = data_generation(n = 200, p = 20, SNR = 9, response = "continuous")
tr_x = tr$x
tr_y = tr$y

te = data_generation(n = 1000, p = 20, SNR = 9, response = "continuous")
te_x = te$x
te_y = te$y

}
