% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NICEClassif.R
\name{NICEClassif}
\alias{NICEClassif}
\title{NICE (Nearest Instance Counterfactual Explanations) for Classification Tasks}
\description{
NICE (Brughmans and Martens 2021) searches for counterfactuals by iteratively replacing feature values
of \code{x_interest} with the corresponding value of its most similar (optionally correctly classified) instance \code{x_nn}.
}
\details{
NICE starts the counterfactual search for \code{x_interest} by finding its most similar (optionally) correctly classified
neighbor \code{x_nn}. \cr
In the first iteration, NICE creates new instances by replacing a different feature value of \code{x_interest} with the corresponding
value of \code{x_nn} in each new instance. Thus, if \code{x_nn} differs from \code{x_interest} in \code{d} features, \code{d} new instances are created. \cr
Then, the reward values for the created instances are computed with the chosen reward function.
Available reward functions are \code{sparsity}, \code{proximity}, and \code{plausibility}. \cr
In the second iteration, NICE creates \code{d-1} new instances by replacing a different feature value of the highest
reward instance of the previous iteration with the corresponding value of \code{x_interest}, and so on. \cr
If \code{finish_early = TRUE}, the algorithm terminates when the predicted \code{desired_class} probability for
the highest reward instance is in the interval \code{desired_prob}; if \code{finish_early = FALSE}, the
algorithm continues until \code{x_nn} is recreated. \cr
Once the algorithm terminated, it depends on \code{return_multiple} which instances
are returned as counterfactuals: if \code{return_multiple = FALSE}, then only the highest reward instance in the
last iteration is returned as counterfactual; if \code{return_multiple = TRUE}, then all instances (of all iterations)
whose predicted \code{desired_class} probability is in the interval \code{desired_prob} are returned as counterfactuals.

If \code{finish_early = FALSE} and \code{return_multiple = FALSE}, then \code{x_nn} is returned as single counterfactual.

This NICE implementation corresponds to the original version of Brughmans and Martens (2021) when
\code{return_multiple = FALSE}, \code{finish_early = TRUE}, and \code{x_nn_correct = TRUE}.
}
\examples{
if (require("randomForest")) {
  # Train a model
  rf = randomForest(Species ~ ., data = iris)
  # Create a predictor object
  predictor = iml::Predictor$new(rf, type = "prob")
  # Find counterfactuals
  nice_classif = NICEClassif$new(predictor)
  cfactuals = nice_classif$find_counterfactuals(
    x_interest = iris[150L, ], desired_class = "versicolor", desired_prob = c(0.5, 1)
  )
  # Print the results
  cfactuals$data
  # Print archive
  nice_classif$archive
}

}
\references{
Brughmans, D., & Martens, D. (2021). NICE: An Algorithm for Nearest Instance Counterfactual Explanations.
\href{https://arxiv.org/abs/2104.07411}{arXiv 2104.07411} v2.

Gower, J. C. (1971). "A General Coefficient of Similarity and Some of its Properties". Biometrics, 27, 623–637.
}
\section{Super classes}{
\code{\link[counterfactuals:CounterfactualMethod]{counterfactuals::CounterfactualMethod}} -> \code{\link[counterfactuals:CounterfactualMethodClassif]{counterfactuals::CounterfactualMethodClassif}} -> \code{NICEClassif}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{x_nn}}{(\code{logical(1)}) \cr
The most similar (optionally) correctly classified instance of \code{x_interest}.}

\item{\code{archive}}{(\code{list()}) \cr
A list that stores the history of the algorithm run. For each algorithm iteration, it has one element containing
a \code{data.table}, which stores all created instances of this iteration together with their
reward values and their predictions.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-NICEClassif-new}{\code{NICEClassif$new()}}
\item \href{#method-NICEClassif-clone}{\code{NICEClassif$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="counterfactuals" data-topic="CounterfactualMethod" data-id="print"><a href='../../counterfactuals/html/CounterfactualMethod.html#method-CounterfactualMethod-print'><code>counterfactuals::CounterfactualMethod$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="counterfactuals" data-topic="CounterfactualMethodClassif" data-id="find_counterfactuals"><a href='../../counterfactuals/html/CounterfactualMethodClassif.html#method-CounterfactualMethodClassif-find_counterfactuals'><code>counterfactuals::CounterfactualMethodClassif$find_counterfactuals()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-NICEClassif-new"></a>}}
\if{latex}{\out{\hypertarget{method-NICEClassif-new}{}}}
\subsection{Method \code{new()}}{
Create a new NICEClassif object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{NICEClassif$new(
  predictor,
  optimization = "sparsity",
  x_nn_correct = TRUE,
  return_multiple = FALSE,
  finish_early = TRUE,
  distance_function = "gower"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{predictor}}{(\link[iml]{Predictor})\cr
The object (created with \code{iml::Predictor$new()}) holding the machine learning model and the data.}

\item{\code{optimization}}{(\code{character(1)})\cr
The reward function to optimize. Can be \code{sparsity} (default), \code{proximity} or \code{plausibility}.}

\item{\code{x_nn_correct}}{(\code{logical(1)})\cr
Should only \emph{correctly} classified data points in \code{predictor$data$X} be considered for the most similar instance search?
Default is \code{TRUE}.}

\item{\code{return_multiple}}{(\code{logical(1)})\cr
Should multiple counterfactuals be returned? If TRUE, the algorithm returns all created instances whose \code{desired_class}
prediction is in the interval \code{desired_prob}. For more information, see the \code{Details} section.}

\item{\code{finish_early}}{(\code{logical(1)})\cr
Should the algorithm terminate after an iteration in which the \code{desired_class} prediction for the highest reward instance
is in the interval \code{desired_prob}. If \code{FALSE}, the algorithm continues until \code{x_nn} is recreated.}

\item{\code{distance_function}}{(\verb{function()} | \code{'gower'} | \code{'gower_c'})\cr
The distance function used to compute the distances between \code{x_interest}
and the training data points for finding \code{x_nn}. If \code{optimization} is set
to \code{proximity}, the distance function is also used for calculating the
distance between candidates and \code{x_interest}.
Either the name of an already implemented distance function
('gower' or 'gower_c') or a function is allowed as input.
If set to 'gower' (default), then Gower's distance (Gower 1971) is used;
if set to 'gower_c', a C-based more efficient version of Gower's distance is used.
A function must have three arguments  \code{x}, \code{y}, and \code{data} and should
return a \code{double} matrix with \code{nrow(x)} rows and maximum \code{nrow(y)} columns.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-NICEClassif-clone"></a>}}
\if{latex}{\out{\hypertarget{method-NICEClassif-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{NICEClassif$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
