% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matching_preprocessing.R
\name{preprocess_matching_vars}
\alias{preprocess_matching_vars}
\title{Preprocess matching variables with automatic checks and scaling}
\usage{
preprocess_matching_vars(
  left,
  right,
  vars,
  auto_scale = TRUE,
  scale_method = "auto",
  check_health = TRUE,
  remove_problematic = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{left}{Data frame of left units}

\item{right}{Data frame of right units}

\item{vars}{Character vector of variable names}

\item{auto_scale}{Logical, whether to perform automatic preprocessing (default: TRUE)}

\item{scale_method}{Scaling method: "auto", "standardize", "range", "robust", or FALSE}

\item{check_health}{Logical, whether to check variable health (default: TRUE)}

\item{remove_problematic}{Logical, automatically exclude constant/all-NA variables (default: TRUE)}

\item{verbose}{Logical, whether to print warnings (default: TRUE)}
}
\value{
A list with class "preprocessing_result" containing:
\itemize{
\item \code{left}: Preprocessed left data frame
\item \code{right}: Preprocessed right data frame
\item \code{vars}: Final variable names (after exclusions)
\item \code{health}: Variable health diagnostics
\item \code{scaling_method}: Selected scaling method
\item \code{excluded_vars}: Variables that were excluded
\item \code{warnings}: List of warnings issued
}
}
\description{
Main preprocessing function that orchestrates variable health checks,
categorical encoding, and automatic scaling selection.
}
