% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gf_resid_gf_squaresid.R
\name{gf_resid}
\alias{gf_resid}
\title{Add Residual Lines to a Plot}
\usage{
gf_resid(plot, model, linewidth = 0.2, ...)
}
\arguments{
\item{plot}{A ggformula plot object, typically created with \code{gf_point()}.}

\item{model}{A fitted linear model object created using \code{lm()}.}

\item{linewidth}{A numeric value specifying the width of the residual lines. Default is \code{0.2}.}

\item{...}{Additional aesthetics passed to \code{geom_segment()}, such as \code{color}, \code{alpha},
\code{linetype}.}
}
\value{
A ggplot object with residual lines added.
}
\description{
This function adds vertical lines representing residuals from a linear model to a ggformula plot.
The residuals are drawn from the observed data points to the predicted values from the model.
}
\examples{
Height_model <- lm(Thumb ~ Height, data = Fingers)
gf_point(Thumb ~ Height, data = Fingers) \%>\%
  gf_model(Height_model) \%>\%
  gf_resid(Height_model, color = "red", alpha = 0.5)
}
