% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{italy_province}
\alias{italy_province}
\title{The 2019 Novel Coronavirus COVID-19 (2019-nCoV) Italy Provinces Outbreak Dataset}
\format{
A data.frame object
}
\source{
Presidenza del Consiglio dei Ministri - Dipartimento della Protezione Civile \href{https://www.protezionecivile.it/}{website}
}
\usage{
italy_province
}
\description{
daily summary of the Coronavirus (COVID-19) pandemic cases in Italy's provinces
}
\details{
The dataset contains the daily summary of the Coronavirus pandemic cases in Italy's regions. The data includes the following fields:

- date - date of notification (Date class)

- region_name - region names

- region_code - region code

- province_name - province names

- province_spatial - the spatial province names as in the output of the `ne_states` function from the **rnaturalearth** package

- province_abb - the province abbreviation

- province_code - province code

- lat - latitude point

- long - Longitude point

- new_cases - daily number of positive cases

- total_cases - total number of positive cases (cumulative)

- nuts_code_1 - groups of region -  level 1 of Italy statistical regions (Nomenclature of Territorial Units for Statistics), more details available \href{https://en.wikipedia.org/wiki/NUTS_statistical_regions_of_Italy}{here}

- nuts_code_2 - regions, level 2 of Italy statistical regions (Nomenclature of Territorial Units for Statistics), more details available \href{https://en.wikipedia.org/wiki/NUTS_statistical_regions_of_Italy}{here}

- nuts_code_3 - provinces, level 3 of Italy statistical regions (Nomenclature of Territorial Units for Statistics), more details available \href{https://en.wikipedia.org/wiki/NUTS_statistical_regions_of_Italy}{here}
}
\examples{

data(italy_province)

head(italy_province)

}
\keyword{COVID19}
\keyword{Italy}
\keyword{coronavirus}
\keyword{datasets}
