% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{circtrans}
\alias{circtrans}
\title{Circular Transformation Formula}
\usage{
circtrans(x, radius = 0, area.prop = TRUE, factor = 1)
}
\arguments{
\item{x}{a numeric vector storing angular values between 0 and 2 pi, or
an object that can be coerced to.}

\item{radius}{the radius of the reference circle.}

\item{area.prop}{logical; if \code{TRUE}, an area-proportional
transformation is applied; if \code{FALSE}, a height-proportional
transformationis applied.}

\item{factor}{a positive number representing the scale factor to scale the
entire plot.}
}
\value{
A numerical vector of the transformed values
}
\description{
The function performs circular transformation of density 
  or frequency, in an area-proportional or height-proportional manner.
}
\examples{
library(circular)
x = as.vector(rvonmises(20, circular(pi), 10))
circtrans(x)                            # area-proportional transformation
circtrans(x, area.prop = FALSE)         # height-proportional transformation
circtrans(x, factor = 2)                # with a scaling factor

}
\references{
Xu, D. and Wang, Y. (2020) Area-proportional Visualization for
Circular Data. \emph{Journal of Computational and Graphical
Statistics}, \bold{29}, 351-357.
}
\seealso{
\code{\link{scalefactor}}
}
\author{
Danli Xu <dxu452@aucklanduni.ac.nz>, Yong Wang <yongwang@auckland.ac.nz>
}
\concept{circular transformation}
