% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qpdf.R
\name{pdf_rotate_pages}
\alias{pdf_rotate_pages}
\title{Rotate pages in a pdf file}
\usage{
pdf_rotate_pages(
  input,
  pages,
  angle = 90,
  relative = FALSE,
  output = NULL,
  password = ""
)
}
\arguments{
\item{input}{path or url to the input pdf file}

\item{pages}{a vector with page numbers to rotate}

\item{angle}{rotation angle in degrees (positive = clockwise)}

\item{relative}{if \code{TRUE}, pages are rotated relative to their current
orientation. If \code{FALSE}, rotation is absolute (0 = portrait, 90 = landscape,
rotated 90 degrees clockwise from portrait)}

\item{output}{base path of the output file(s)}

\item{password}{string with password to open pdf file}
}
\value{
a character vector with the path of the rotated pdf file
}
\description{
Rotate pages in a pdf file
}
\examples{
pdf_file <- system.file("examples", "sufganiyot.pdf", package = "cpp11qpdf")
fout <- tempfile()
pdf_rotate_pages(pdf_file, 1, 90, FALSE, fout, "")
}
