% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cnr.R
\name{cnr}
\alias{cnr}
\title{Control Net Reduction}
\usage{
cnr(x, margin, n_polycoef = 20L, progress = c("cnr", "influence", "none"), ...)
}
\arguments{
\item{x}{a \code{cnr_cn} object}

\item{margin}{the margins to apply the CNR algorithm to.  Passed to
\code{\link{influence_weights}}.}

\item{n_polycoef}{the number of polynomial coefficients to use when assessing
the influence of each internal knot.}

\item{progress}{controls the level of progress messaging.}

\item{...}{not currently used}
}
\value{
A \code{cpr_cnr} object.  This is a list of \code{cpr_cn} objects.
}
\description{
Run the Control Net Reduction Algorithm.
}
\details{
\code{cnr} runs the control net reduction algorithm.

\code{keep} will keep the regression fit as part of the \code{cnr\_cp} object
for models with up to and including keep fits.  For example, if \code{keep =
10} then the resulting \code{cnr\_cnr} object will have the regression fit
stored in the first \code{keep + 1} (zero internal knots, one internal knot,
\ldots, \code{keep} internal knots) \code{cnr\_cp} objects in the list.  The
limit on the number of stored regression fits is to keep memory usage down.
}
\examples{

acn <- cn(log10(pdg) ~ btensor(list(day, age)
                               , df = list(10, 8)
                               , bknots = list(c(-1, 1), c(44, 53)))
         , data = spdg)
cnr0 <- cnr(acn)
cnr0
summary(cnr0)
plot(cnr0)

}
\seealso{
\code{\link{cn}} for defining a control net,
\code{\link{influence_weights}} for finding the influence of the internal
knots, \code{\link{cpr}} for the univariate version, Control Polygon
Reduction.

\code{vignette(topic = "cnr", package = "cpr")}
}
