% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dcf.R
\name{cf_compute_levered}
\alias{cf_compute_levered}
\title{Equity cash flows and metrics in the presence of debt}
\usage{
cf_compute_levered(dcf_res, debt_sched, cfg)
}
\arguments{
\item{dcf_res}{list. Result of \code{dcf_calculate()}. Must contain:
\itemize{
\item \code{inputs} with at least \code{acq_price}, \code{disc_rate}, \code{exit_yield},
\item \code{cashflows} with at least \code{year}, \code{free_cash_flow}, \code{sale_proceeds},
\code{net_operating_income}.
}}

\item{debt_sched}{data.frame or tibble. Debt schedule (output of
\code{debt_built_schedule()}). Minimal columns: \code{year}, \code{payment},
\code{interest}, \code{amortization}, \code{outstanding_debt}. Years must be
compatible with \code{dcf_res$cashflows$year}.}

\item{cfg}{list. Financing parameters. Must contain \code{ltv_init}. Optional:
\code{arrangement_fee_pct} (default 0) and \code{capitalized_fees} (default TRUE).}
}
\value{
A list with:
\itemize{
\item \code{equity_cf}: numeric vector of equity cash flows,
\item \code{metrics}: list with \code{irr_equity}, \code{npv_equity},
\code{equity_0}, \code{loan_draw_0},
\item \code{full}: \code{dcf_res$cashflows} enriched by \code{add_credit_ratios()}.
}
}
\description{
Computes equity cash flows over \eqn{t = 0..N} from an unlevered Discounted Cash Flow (DCF) and an
annual debt schedule, then derives equity IRR and equity NPV. The convention
is that \code{free_cash_flow} includes the acquisition at \eqn{t = 0} as a
negative flow and includes operating free cash flows for \eqn{t >= 1}. Sale
proceeds are booked at \eqn{t = N} via \code{sale_proceeds}.
}
\examples{
dcf <- dcf_calculate(
  acq_price = 1e7, entry_yield = 0.05, exit_yield = 0.055,
  horizon_years = 10, disc_rate = 0.07
)
sch <- debt_built_schedule(
  principal = 6e6, rate_annual = 0.045, maturity = 5, type = "bullet"
)
out <- cf_compute_levered(
  dcf_res = dcf,
  debt_sched = sch,
  cfg = list(ltv_init = 0.6, arrangement_fee_pct = 0, capitalized_fees = TRUE)
)
stopifnot(is.numeric(out$metrics$irr_equity) || is.na(out$metrics$irr_equity))
stopifnot(is.numeric(out$equity_cf))
}
