% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Backfill-class.R
\docType{class}
\name{OpeningMinResponses-class}
\alias{OpeningMinResponses-class}
\alias{.OpeningMinResponses}
\alias{OpeningMinResponses}
\alias{.DefaultOpeningMinResponses}
\title{\code{OpeningMinResponses}}
\usage{
OpeningMinResponses(min_responses = 1L, include_lower_doses = FALSE)

.DefaultOpeningMinResponses()
}
\arguments{
\item{min_responses}{(\code{count})\cr see slot definition.}

\item{include_lower_doses}{(\code{logical})\cr see slot definition.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

\code{\link{OpeningMinResponses}} opens backfill cohorts when a minimum number of
responses has been observed in the trial. The responses can be counted
at the cohort's dose level only, or also at lower dose levels if
\code{include_lower_doses} is set to \code{TRUE}.
}
\section{Slots}{

\describe{
\item{\code{min_responses}}{(\code{count})\cr the minimum number of responses
required before backfill cohorts can be opened (at least 1).}

\item{\code{include_lower_doses}}{(\code{logical})\cr if \code{TRUE}, responses at all
doses less than or equal to the cohort's dose are counted. If \code{FALSE},
only responses at the cohort's dose are counted.}
}}

\note{
Typically, end users will not use the \code{.DefaultOpeningMinResponses()} function.
}
\examples{
# Create an OpeningMinResponses object that requires 2 responses
opening <- OpeningMinResponses(min_responses = 2, include_lower_doses = FALSE)

# Display the object
print(opening)

# Create a variant that includes lower doses
opening_inclusive <- OpeningMinResponses(
  min_responses = 2,
  include_lower_doses = TRUE
)
print(opening_inclusive)
}
\seealso{
\code{\link{Opening}} and the other subclasses listed in there.
}
