% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crop.R
\name{crop_circle}
\alias{crop_circle}
\alias{crop_square}
\alias{crop_hex}
\alias{crop_heart}
\alias{crop_parallelogram}
\alias{circle_crop}
\alias{hex_crop}
\title{Cropping functions}
\usage{
crop_circle(
  images,
  to = NULL,
  border_size = NULL,
  border_colour = "black",
  bg_fill = NULL,
  just = "center"
)

crop_square(
  images,
  to = NULL,
  border_size = NULL,
  border_colour = "black",
  bg_fill = NULL,
  just = "center"
)

crop_hex(
  images,
  to = NULL,
  border_size = NULL,
  border_colour = "black",
  bg_fill = NULL,
  just = "center"
)

crop_heart(
  images,
  to = NULL,
  border_size = NULL,
  border_colour = "black",
  bg_fill = NULL,
  just = "center"
)

crop_parallelogram(
  images,
  to = NULL,
  border_size = NULL,
  border_colour = "black",
  bg_fill = NULL,
  just = "center"
)

circle_crop(
  images,
  to = NULL,
  border_size = NULL,
  border_colour = "black",
  bg_fill = NULL,
  just = "center"
)

hex_crop(
  images,
  to = NULL,
  border_size = NULL,
  border_colour = "black",
  bg_fill = NULL,
  just = "center"
)
}
\arguments{
\item{images}{Vector of image paths, either local or urls. If urls the images
will be downloaded first.}

\item{to}{Path to new location}

\item{border_size}{Border size in pixels.}

\item{border_colour}{Border colour.}

\item{bg_fill}{Background fill. Allows a different colour for the background and
a different colour for the border.}

\item{just}{Where to justify the image prior to cropping. Accepted values:
`left`, `right`, `top`, `bottom`}
}
\value{
Path to cropped images
}
\description{
Reads in an image and crops to the specified geometry with a transparent
background. If a new path is given it will save the cropped images to
the new location. If no path is given it will save to a temporary location
which will be cleared when the session is closed
}
\note{
The naming convention is now `crop_*`. The old functions
`circle_crop` and `hex_crop` still work but you are encouraged to use the new
functions `crop_circle` and `crop_hex`.
}
\examples{
library(cropcircles)
library(magick)

img_path <- file.path(system.file(package = "cropcircles"), "images", "walter-jesse.png")
img_cropped <- crop_circle(img_path, border_size = 6)
image_read(img_cropped)

# justification example

# center (default)
image_read(crop_circle(img_path, border_size = 6))

# left
image_read(crop_circle(img_path, border_size = 6, just = "left"))

# right
image_read(crop_circle(img_path, border_size = 6, just = "right"))
}
