% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xfr_surrogate.R
\name{xfr_surrogate}
\alias{xfr_surrogate}
\title{A function for estimating the proportion of treatment effect explained using repeated cross-fitting.}
\usage{
xfr_surrogate(
  ds,
  x = NULL,
  s,
  y,
  a,
  splits = 50,
  K = 5,
  outcome_learners = NULL,
  ps_learners = NULL,
  interaction_model = TRUE,
  trim_at = 0.05,
  outcome_family = gaussian(),
  mthd = "superlearner",
  n_ptb = 0,
  ...
)
}
\arguments{
\item{ds}{a \code{data.frame}.}

\item{x}{names of all covariates in \code{ds} that should be included to control for confounding (eg. age, sex, etc). Default is \code{NULL}.}

\item{s}{names of surrogates in \code{ds}.}

\item{y}{name of the outcome in \code{ds}.}

\item{a}{treatment variable name (eg. groups). Expect a binary variable made of \code{1}s and \code{0}s.}

\item{splits}{number of data splits to perform.}

\item{K}{number of folds for cross-fitting. Default is \code{5}.}

\item{outcome_learners}{string vector indicating learners to be used for estimation of the outcome function (e.g., \code{"SL.ridge"}). See the SuperLearner package for details.}

\item{ps_learners}{string vector indicating learners to be used for estimation of the propensity score function (e.g., \code{"SL.ridge"}). See the SuperLearner package for details.}

\item{interaction_model}{logical indicating whether outcome functions for treated and control should be estimated separately. Default is \code{TRUE}.}

\item{trim_at}{threshold at which to trim propensity scores. Default is \code{0.05}.}

\item{outcome_family}{default is \code{'gaussian'} for continuous outcomes. Other choice is \code{'binomial'} for binary outcomes.}

\item{mthd}{selected regression method. Default is \code{'superlearner'}, which uses the \code{SuperLearner} package for estimation. Other choices include \code{'lasso'} (which uses \code{glmnet}), \code{'sis'} (which uses \code{SIS}), \code{'cal'} (which uses \code{RCAL}).}

\item{n_ptb}{Number of perturbations. Default is \code{0} which means asymptotic standard errors are used.}

\item{...}{additional parameters (in particular for super_learner)}
}
\value{
a \code{tibble} with columns: \itemize{
   \item \code{Rm}: estimate of the proportion of treatment effect explained, computed as the median over the repeated splits.
   \item \code{R_se0} standard error for the PTE, accounting for the variability due to splitting.
   \item \code{R_cil0} lower confidence interval value for the PTE.
   \item \code{R_cih0} upper confidence interval value for the PTE.
   \item \code{Dm}: estimate of the overall treatment effect,  computed as the median over the repeated splits.
   \item \code{D_se0} standard error for the overall treatment effect, accounting for the variability due to splitting.
   \item \code{D_cil0} lower confidence interval value for the overall treatment effect.
   \item \code{D_cih0} upper confidence interval value for the overall treatment effect.
   \item \code{Dsm}: estimate of the residual treatment effect, computed as the median over the repeated splits.
   \item \code{Ds_se0} standard error for the residual treatment effect, accounting for the variability due to splitting.
   \item \code{Ds_cil0} lower confidence interval value for the residual treatment effect.
   \item \code{Ds_cih0} upper confidence interval value for the residual treatment effect.
   }
}
\description{
A function for estimating the proportion of treatment effect explained using repeated cross-fitting.
}
\examples{

n <- 100
p <- 20
q <- 2
wds <- sim_data(n = n, p = p)

if(interactive()){
 lasso_est <- xfr_surrogate(ds = wds,
   x = paste('x.', 1:q, sep =''),
   s = paste('s.', 1:p, sep =''),
   a = 'a',
   y = 'y',
   splits = 2,
   K = 2,
   trim_at = 0.01,
   mthd = 'lasso',
   ncores = 1)
}

}
