% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{calculate_centroids_flexible}
\alias{calculate_centroids_flexible}
\alias{calculate_centroids_normalized}
\alias{calculate_centroids_terraneous}
\title{Searches modes with the AMS3D algorithm for a lidar point cloud of a forest}
\usage{
calculate_centroids_flexible(
  coordinate_table,
  min_point_height_above_ground,
  ground_height_data,
  crown_diameter_to_tree_height_data,
  crown_length_to_tree_height_data,
  crown_diameter_constant,
  crown_length_constant,
  centroid_convergence_distance,
  max_iterations_per_point,
  also_return_all_centroids,
  show_progress_bar
)

calculate_centroids_normalized(
  coordinate_table,
  min_point_height_above_ground,
  crown_diameter_to_tree_height,
  crown_length_to_tree_height,
  crown_diameter_constant,
  crown_length_constant,
  centroid_convergence_distance,
  max_iterations_per_point,
  also_return_all_centroids,
  show_progress_bar
)

calculate_centroids_terraneous(
  coordinate_table,
  min_point_height_above_ground,
  ground_height_grid_data,
  crown_diameter_to_tree_height,
  crown_length_to_tree_height,
  crown_diameter_constant,
  crown_length_constant,
  centroid_convergence_distance,
  max_iterations_per_point,
  also_return_all_centroids,
  show_progress_bar
)
}
\arguments{
\item{coordinate_table}{A \code{data.frame}. The first three columns are
treated as the x-, y-, and z-coordinates of an airborne lidar point
cloud.}

\item{min_point_height_above_ground}{A single positive number. The minimum
point height above ground at which the function will calculate
centroids.}

\item{ground_height_data}{A list containing either a single ground height
value (named "value") or a set of elements that make up a ground height
raster covering the whole area of the point cloud. Such a set has to
consist of the named elements described in the section "Raster argument
structure" below.}

\item{crown_diameter_to_tree_height_data}{A list containing either a single
numeric value (named "value") or the data for a raster of values (see
section "Raster argument structure" below for how the raster data has to
be stored in the list). The values indicate the estimated ratio of crown
diameter to tree height for the whole plot or individual raster pixels
respectively.}

\item{crown_length_to_tree_height_data}{A list containing either a single
numeric value (named "value") or the data for a raster of values (see
section "Raster argument structure" below for how the raster data has to
be stored in the list). The values indicate the estimated ratio of crown
height to tree height for the whole plot or individual raster pixels
respectively.}

\item{crown_diameter_constant}{Single number >=0. Intercept for the linear
function determining the kernel diameter (bandwidth) in relationship to
the height above ground.}

\item{crown_length_constant}{Single number >=0.  Intercept for the linear
function determining the kernel height (bandwidth) in relationship to
the height above ground.}

\item{centroid_convergence_distance}{Numeric Scalar. Distance at which it is
assumed that subsequently calculated centroids have converged to the
nearest mode.}

\item{max_iterations_per_point}{Integer Scalar. Maximum number of
centroids calculated before the search for the nearest mode stops.}

\item{also_return_all_centroids}{Boolean Scalar. Should all centroid coordinates be
returned as well?}

\item{show_progress_bar}{Boolean Scalar. Should a progress bar be shown
during the computation?}

\item{crown_diameter_to_tree_height, crown_length_to_tree_height}{Single
numbers. Determine the size of the search kernel (bandwidth) of the
algorithm, as a function of height above ground. The kernel should have
roughly the size of the expected tree crowns. If the intercepts are
zero, the slopes translate to ratios of crown diameter to tree height
or crown length to tree height, respectively.}

\item{ground_height_grid_data}{A list containing a set of elements that make
up a ground height raster covering the whole area of the point cloud.
The set has to consist of the named elements described in the section
"Raster argument structure" below.}
}
\value{
A list with either one or two elements:
\itemize{
\item The first element (named
"terminal_coordinates") contains the terminal centroids for all points in the
\code{coordinate_table}. These are stored in a \code{data.frame}
with three columns that hold the x-, y-, and z-coordinates and they are
stored in the same order as their respective points in the
\code{coordinate_table}.
\item The second element (named "centroid_coordinates") is only present if
\code{also_return_all_centroids} was set to \code{TRUE} and contains the
centroids calculated during the mode finding process. The prior centroids are
stored in a \code{data.frame} with xyz-coordinate columns like the
terminal centroids. To enable grouping of these centroids by the point they belong
to, there is one additional column (named "point_index") which holds row
indices of the corresponding points in the \code{coordinate_table}.
}
}
\description{
Employs the 3D adaptive mean shift algorithm (Ferraz et al., 2016) to
estimate the mode of each point in a point cloud which is assumed to contain
trees. In this context the mode is a theoretical "center of mass" of a tree
crown point cloud, that is usually located shortly below the crown apex.
}
\section{Functions}{
\itemize{
\item \code{calculate_centroids_flexible()}: Can take either a single value or
raster data for both the ground height and the
\code{crown_diameter_to_tree_height} and
\code{crown_length_to_tree_height} parameters.

\item \code{calculate_centroids_terraneous()}: Use a ground height raster to find
modes in a non-normalized point cloud.

}}
\section{Raster argument structure}{

Raster data has to be passed as a list comprising the following named
elements:
\itemize{
\item values: Numeric vector holding the values.
\item num_rows: Integer number indicating the number of rows.
\item num_cols: Integer number indicating the number of columns.
\item x_min: Number indicating the lowest x coordinate covered.
\item x_max: Number indicating the largest x coordinate covered.
\item y_min: Number indicating the lowest y coordinate covered.
\item y_max: Number indicating the largest y coordinate covered.
}
}

\references{
Ferraz, A., S. Saatchi, C. Mallet, and V. Meyer (2016)
\emph{Lidar detection of individual tree size in tropical forests}.
Remote Sensing of Environment 183:318–333.
\doi{10.1016/j.rse.2016.05.028}.
}
