% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/suggest_crs.R
\name{view_crs}
\alias{view_crs}
\title{Quickly preview the extent of a given CRS using mapview}
\usage{
view_crs(crs)
}
\arguments{
\item{crs}{A character string representing the EPSG code of an input coordinate reference system, possibly returned by \code{suggest_top_crs}.}
}
\value{
an object of class \code{mapview} which uses the mapview package to preview the extent of a coordinate reference system.
}
\description{
The crsuggest package makes coordinate reference systems \emph{suggestions} that may not be perfect for your specific analytic use case.  Use \code{view_crs()} to quickly view the geographic extent of a given coordinate reference system (represented by its EPSG code) and assess whether that CRS makes sense for your data.
}
\examples{
\dontrun{

library(tigris)
library(crsuggest)
options(tigris_use_cache = TRUE)

# Get a Census tract dataset from the tigris package
tarrant_tracts <- tracts("TX", "Tarrant", cb = TRUE, year = 2021)

# Suggest a CRS for your data
target_crs <- suggest_top_crs(tarrant_tracts, units = "m", inherit_gcs = FALSE)

# Preview the extent of the CRS
view_crs(target_crs)

}
}
