% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/csa.R
\name{csas}
\alias{csas}
\title{Estimate and print the spatial CSA plot}
\usage{
csas(
  x,
  stat = "var",
  std = TRUE,
  plot = TRUE,
  threshold = 30,
  chk = FALSE,
  ...
)
}
\arguments{
\item{x}{A raster or brick object.}

\item{stat}{The statistic which will be estimated across the cross-scale continuum. Suitable options are:
\itemize{
\item{"var" for variance,}
\item{"sd" for standard deviation,}
\item{"skew" for skewness,}
\item{"kurt" for kurtosis,}
\item{"l2" for L-scale,}
\item{"t2" for coefficient of L-variation,}
\item{"t3" for L-skewness,}
\item{"t4" for L-kurtosis.}
}}

\item{std}{logical. If TRUE (the default) the CSA plot is standardized to unit, i.e., zero mean and unit variance in the original time scale.}

\item{plot}{logical. If TRUE (the default) the CSA plot is printed}

\item{threshold}{numeric. Sample size of the time series at the last aggregated scale.}

\item{chk}{logical. If TRUE the number of cores is limited to 2.}

\item{...}{log_x and log_y (default TRUE) for setting the axes of the CSA  plot to logarithmic scale. The argument wn (default FALSE) is used to plot a line presenting the standardized variance of the white noise process. Therefore, it should be used only with stat = "var" and std = T.}
}
\value{
If \code{plot = TRUE}, the \code{csa} returns a list containing:
 \itemize{
 \item{\code{values}: Matrix of the timeseries values for the selected \code{stat} at each \code{scale}.}
 \item{\code{plot}: Plot of \code{scale} versus \code{stat} as a \emph{ggplot} object.}
 }
 If \code{plot = FALSE}, then it returns only the matrix of the timeseries values for the selected \code{stat} at each \code{scale}.
}
\description{
The function \code{csa} computes (and by default plots) the aggregation curve of a given statistic in two dimensions, e.g., space.
}
\examples{
\dontrun{
data(gpm_events)
event_dates <- format(gpm_events[, unique(time)], "\%d-\%m-\%Y")
gpm_events_brick <- dt.to.brick(gpm_events, var_name = "prcp")
plot(gpm_events_brick, col = rev(colorspace::sequential_hcl(40)),
     main = event_dates)
csas(gpm_events_brick, chk = TRUE)

gpm_sp_scale <- csas(gpm_events_brick, plot = FALSE, chk = TRUE)
gpm_sp_scale[, variable := factor(variable, labels = event_dates)]
csa.multiplot(gpm_sp_scale, smooth = TRUE, log_x = FALSE, log_y = FALSE)
}
}
\references{
Markonis et al., A cross-scale analysis framework for model/data comparison and integration, Geoscientific Model Development, Submitted.
}
