% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mds.ct.R
\name{procrustes.mds.ct}
\alias{procrustes.mds.ct}
\title{Procrustes transformation for continuous-time multidimensional scaling}
\usage{
procrustes.mds.ct(obj, points, coord = NULL)
}
\arguments{
\item{obj}{an object of class "\code{\link{mds.ct}}"}

\item{points}{matrix of classical principal coordinates, 
e.g. as produced by \code{\link{cmdscale}}}

\item{coord}{which coordinates to transform.}
}
\value{
The output of \code{\link[vegan]{procrustes}}.
}
\description{
Matches classical principal coordinates
to continuous-time principal coordinates produced by \code{\link{mds.ct}},
via Procrustes transformation.
}
\note{
The function uses \code{\link[vegan]{procrustes}}, from the \code{vegan}
package, to transform the classical 
principal coordinates given by \code{points}
to the continuous-time principal coordinates defined by \code{obj}, evaluated at the
time points given therein. By default, all of the coordinates are used. If \code{obj} and 
\code{points} do not include the same number of coordinates, the smaller number
is used, and a warning is issued.
}
\examples{
# see call to plot.procrustes.ct in mds.ct example

}
\seealso{
\code{\link{procrustes.plot.mds}}
}
\author{
Philip Tzvi Reiss <reiss@stat.haifa.ac.il>
}
