% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chemical-APIs-batch.R
\name{get_chemicals_in_list_contain_batch}
\alias{get_chemicals_in_list_contain_batch}
\title{Get chemicals in a list specified by characters contained batch search}
\usage{
get_chemicals_in_list_contain_batch(
  list_names = NULL,
  words = NULL,
  API_key = NULL,
  rate_limit = 0L,
  verbose = FALSE
)
}
\arguments{
\item{list_names}{The names of the lists to search.}

\item{words}{The search words, one for each list.}

\item{API_key}{The user-specific API key.}

\item{rate_limit}{Number of seconds to wait between each request.}

\item{verbose}{A logical indicating if some "progress report" should be given.}
}
\value{
A named list of lists, with names corresponding to search terms and
lists corresponding to DTXSIDs associated to the search terms
}
\description{
Get chemicals in a list specified by characters contained batch search
}
\examples{
\dontshow{if (FALSE) withAutoprint(\{ # examplesIf}
# Search `CCL4` for chemicals containing with 'Bis' and `BIOSOLIDS2021` for
# chemicals containing with 'Zyle'.
bis_and_zyle <- get_chemicals_in_list_contain_batch(list_names = c('CCL4',
                                                              'BIOSOLIDS2021'),
                                                 words = c('Bis', 'Zyle'))
\dontshow{\}) # examplesIf}
}
