% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cb.R
\name{cb}
\alias{cb}
\title{Restricted cubic splines}
\usage{
cb(x, df = NULL, knots = NULL, ortho = FALSE, R.inv = NULL, intercept = FALSE)
}
\arguments{
\item{x}{Values to evaluate the basis functions in.}

\item{df}{Degrees of freedom. One can supply \code{df} rather than knots; \code{cb} then chooses \code{df + 1} knots
at suitably chosen quantiles of \code{x} (which will ignore missing values).}

\item{knots}{Chosen knots for the spline.}

\item{ortho}{Logical. If \code{TRUE} orthogonalization of the basis matrix is carried out.}

\item{R.inv}{Matrix or vector containing the values of the R matrix from the QR decomposition of the basis matrix.
This is used for making new predictions based on the initial orthogonalization.
Therefore the default is \code{NULL}.}

\item{intercept}{Logical. If \code{FALSE}, the intercept of the restricted cubic spline is removed.}
}
\value{
A matrix with containing the basis functions evaluated in \code{x}.
}
\description{
Function for computing the basis matrix for restricted cubic splines
}
\references{
Royston P. and Parmar M.K. (2002) Flexible parametric proportional-hazards and proportional-odds
models for censored survival data, with application to prognostic modelling and
estimation of treatment effects. \emph{Statistics in Medicine}, 21:15.
}
