% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apply_by_blocks.R
\name{balance_by_blocks}
\alias{balance_by_blocks}
\title{Balance matrix by blocks}
\usage{
balance_by_blocks(Y, col_totals = NULL, row_totals = NULL, layout, L)
}
\arguments{
\item{Y}{Matrix to be balanced.}

\item{col_totals}{Desired colSums for each block. See details.}

\item{row_totals}{Desired rowSums for each block. See details.}

\item{layout}{The blocks are distributed: 1 horizontally, 2 vertically.}

\item{L}{Number of lines that a block encompasses.}
}
\value{
The balanced matrix.
}
\description{
Applies \code{balance_matrix()} to equally-sized blocks that partition the
matrix either vertically or horizontally.
}
\details{
When Y is composed of **vertically** stacked blocks, col_totals must be
a matrix whose rows are the colSums for each block, and row_totals
just a (vertical) vector.

When Y is composed of blocks arraged **horizontally**, col_totals is a
(horizontal) vector, and row_totals is a matrix whose columns are the rowSums
for each block.
}
\examples{
set.seed(10)
Y <- (rnorm(32)*10) |> matrix(ncol = 2) |> round(3)
v <- aggregate(Y, by = list(rep(1:4, times = rep(4,4))), FUN = sum)[, -1] |>
  round() |> as.matrix()
X <- balance_by_blocks(Y, v, layout = 2, L = 4)
U <- Y[5:8,] |> balance_matrix(v[2,])
X[5:8,] - U
}
