% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codon_weight.R
\name{est_optimal_codons}
\alias{est_optimal_codons}
\title{Identify optimal codons using statistical modeling}
\usage{
est_optimal_codons(
  cf,
  codon_table = get_codon_table(),
  level = "subfam",
  gene_score = NULL,
  fdr = 0.001
)
}
\arguments{
\item{cf}{A matrix of codon frequencies as calculated by \code{count_codons()}.
Rows represent sequences and columns represent codons.}

\item{codon_table}{A codon table defining the genetic code, derived from 
\code{get_codon_table()} or \code{create_codon_table()}.}

\item{level}{Character string specifying the analysis level: "subfam" (default, 
analyzes codon subfamilies) or "amino_acid" (analyzes at amino acid level).}

\item{gene_score}{A numeric vector of gene-level scores used to identify 
optimal codons. Length must equal the number of rows in \code{cf}. Common 
choices include:
\itemize{
  \item Gene expression levels (RPKM, TPM, FPKM) - optionally log-transformed
  \item Protein abundance measurements
  \item Custom gene importance scores
}
If not provided, the negative of ENC values will be used (lower ENC = higher bias).}

\item{fdr}{Numeric value specifying the false discovery rate threshold for 
determining statistical significance of codon optimality (default depends on method).}
}
\value{
A data.table containing the input codon table with additional columns 
  indicating codon optimality status, statistical significance, and effect sizes 
  from the regression analysis. The columns include single-letter abbreviation 
  of the amino acid, three-letter abbreviation, codon, codon subfamily, 
  regression coefficient, regression P-value, Benjamini and Hochberg corrected 
  Q-value, and indication of whether the codon is optimal.
}
\description{
\code{est_optimal_codons} identifies optimal codons within each codon family 
or amino acid group using binomial regression. Optimal codons are those whose 
usage correlates positively with high gene expression or negatively with 
codon usage bias (ENC), suggesting they are preferred for efficient translation.
}
\examples{
# perform binomial regression for optimal codon estimation
cf_all <- count_codons(yeast_cds)
codons_opt <- est_optimal_codons(cf_all)
codons_opt <- codons_opt[optimal == TRUE]
codons_opt

}
\references{
Presnyak V, Alhusaini N, Chen YH, Martin S, Morris N, Kline N, Olson S, 
Weinberg D, Baker KE, Graveley BR, et al. 2015. Codon optimality is a major 
determinant of mRNA stability. Cell 160:1111-1124.
}
