# Cultural evolution in R

[![Travis-CI Build Status](https://travis-ci.org/kevinstadler/cultevo.svg?branch=master)](https://travis-ci.org/kevinstadler/cultevo) [![Code Coverage](https://codecov.io/gh/kevinstadler/cultevo/branch/master/graphs/badge.svg)](https://codecov.io/gh/kevinstadler/cultevo/) [![CRAN Status Badge](http://www.r-pkg.org/badges/version/cultevo)](https://kevinstadler.github.io/cultevo/)

The **cultevo** R package provides tools, measures and statistical tests often used in the study of cultural evolution, in particular for measuring the compositionality of signalling systems as well as computing string and meaning distance matrices. It also provides an accurate implementation of Page's test for monotonicity of ranks.

See the [Function reference](https://kevinstadler.github.io/cultevo/reference/index.html) for a full list of functions.

## Installation

In order to install the latest development version you first need the [devtools](https://CRAN.R-project.org/package=devtools) package

    install.packages("devtools")

then install the latest code from the github repository via

    devtools::install_github("kevinstadler/cultevo")

## Citation

This package can be cited as:

> Stadler, Kevin (2018) cultevo: Tools, Measures and Statistical Tests for Cultural Evolution. R package version 1.0.2. https://kevinstadler.github.io/cultevo/

A BibTeX entry for LaTeX users is

```
  @Manual{cultevo,
    title = {cultevo: Tools, Measures and Statistical Tests for Cultural Evolution},
    author = {Kevin Stadler},
    year = {2018},
    note = {R package version 1.0.2},
    url = {https://kevinstadler.github.io/cultevo/}
  }
```

## License

This project is licensed under the terms of the [MIT license](http://opensource.org/licenses/MIT), Copyright (c) 2014-2018 Kevin Stadler.
