% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dists.R
\name{orderinsensitivedists}
\alias{orderinsensitivedists}
\title{Calculate the bag-of-characters similarity between strings.}
\usage{
orderinsensitivedists(strings = NULL, split = NULL,
  segmentcounts = segment.counts(strings, split))
}
\arguments{
\item{strings}{a vector or list of strings}

\item{split}{boundary sequency at which to segment the strings (default
splits the string into all its constituent characters)}

\item{segmentcounts}{if custom segmentation is required, the pre-segmented
strings can be passed as this argument (which is a list of lists)}
}
\value{
a distance matrix
}
\description{
Calculate the bag-of-characters similarity between strings.
}
\examples{
orderinsensitivedists(c("xxxx", "asdf", "asd", "dsa"))
}
\seealso{
\code{\link[stats]{dist}}
}
