% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/3-Style.R
\name{style}
\alias{style}
\title{Add Color & Attributes to a Character}
\usage{
style(x, fg = NA, bg = NA, attr = NA)
}
\arguments{
\item{x}{character vector to be styled}

\item{fg}{character or numeric value for the foreground color. See \code{\link{fg_on}} for more details.}

\item{bg}{character or numeric value for the background color. See \code{\link{bg_on}} for more details.}

\item{attr}{character vector describing attributes to turn on. See \code{\link{attr_on}} for more details.}
}
\value{
character vector
}
\description{
Add color and other text attributes to a character vector. Attributes can be seen after text is passed to \code{cat}, though it may only show up in a terminal. Note that terminal attributes and colors are automatically reset to default after text is printed.
}
\examples{
x <- style("Hello World!\n", fg="blue", bg=c(192,192,192), attr=c("ul", "st"))
cat(paste(x, "It is nice to meet you!"))

}
\seealso{
Other style functions: 
\code{\link{attr_off}()},
\code{\link{attr_on}()},
\code{\link{bg_off}()},
\code{\link{bg_on}()},
\code{\link{color_off}()},
\code{\link{color_pair}()},
\code{\link{fg_off}()},
\code{\link{fg_on}()},
\code{\link{make_bg}()},
\code{\link{make_fg}()},
\code{\link{make_style}()},
\code{\link{reset}()}
}
\concept{style functions}
