% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/curve.R, R/npcurve.R
\name{predict.curvir}
\alias{predict.curvir}
\alias{predict.npcurvir}
\title{Predict method for curvir reserve demand models}
\usage{
\method{predict}{curvir}(object, newdata = NULL, newdummy = NULL, ...)

\method{predict}{npcurvir}(object, newdata = NULL, newdummy = NULL, ...)
}
\arguments{
\item{object}{A model fit with \code{\link{npcurve}}.}

\item{newdata}{New input data organised as the x matrix in \code{\link{curve}}. If \code{NULL} then the data used to fit the model is re-used.}

\item{newdummy}{New input dummy organised as the dummy vector in \code{\link{curve}}. If \code{NULL} then the dummy used to fit the model is re-used.}

\item{...}{Further arguments (unused)}
}
\value{
Returns a matrix of predicted values. If the model has estimates for intervals then it will provide upper and lower intervals.

Returns a matrix of predicted values. If the model has estimates for intervals then it will provide upper and lower intervals.
}
\description{
Predicted values based on curvir model object

Predicted values based on npcurvir model object
}
\section{Methods (by class)}{
\itemize{
\item \code{predict(curvir)}: Predicted values for parametric curves

\item \code{predict(npcurvir)}: Predicted values for non-parametric curves

}}
\examples{
\dontshow{
  rate <- head(ecb$rate,10)
  x <- ecb$x[1:10,1,drop=FALSE]
  fit <- curve(x,rate,rep=1,type="fixExponential")
  predict(fit)
}
\donttest{
  # Use ECB example data
  rate <- ecb$rate
  x <- ecb$x[,1,drop=FALSE]
  fit <- curve(x,rate)
  predict(fit)

  # An example with new data
  predict(fit,newdata=tail(x))
 }

# Use ECB example data
rate <- ecb$rate
x <- ecb$x[,1,drop=FALSE]
fit <- npcurve(x,rate)
predict(fit)

}
\references{
Chen, Z., Kourentzes, N., & Veyrune, R. (2023). \href{https://www.imf.org/en/Publications/WP/Issues/2023/09/01/Modeling-the-Reserve-Demand-to-Facilitate-Central-Bank-Operations-538754}{Modeling the Reserve Demand to Facilitate Central Bank Operations.} IMF Working Papers, 2023(179).
}
\seealso{
\code{\link{curve}}.

\code{\link{npcurve}}.
}
\author{
Nikolaos Kourentzes, \email{nikolaos@kourentzes.com}
}
