% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/moments.R
\name{moments}
\alias{moments}
\title{Moments Computed in Multiple Precision Using the Package Rmpfr}
\usage{
moments(which.f, r, nbits)
}
\arguments{
\item{which.f}{a list specifying the nonnegative integrable
weight function \eqn{f}, with the following 3 components:
(i)  name (in the form of a character string),
(ii) support specified by a 2-vector of the endpoints of the interval,
(iii)  parameter vector when \eqn{f} belongs to a family of
weight functions and is specified by the value of this
parameter vector (if \eqn{f} is already fully specified
then the parameter vector is set to \code{NULL})}

\item{r}{nonnegative integer, specifying that it is the \code{r}'th moment for the weight function \eqn{f} that is to be computed}

\item{nbits}{number of bits in the multiple precision numbers used by the \code{R} package \code{Rmpfr}
to carry out the computation of the \code{r}'th moment}
}
\value{
The \code{r}'th moment with number of bits of precision
\code{nbits} used in its computation, via the \code{R} package \code{Rmpfr}
}
\description{
This module computes the \code{r}'th moment
\deqn{\int_{-\infty}^{\infty} x^r f(x) dx,}
where \eqn{f} is the weight function (specified by the list \code{which.f}), for any nonnegative integer \code{r} using \code{nbits} bits of precision for its computation, via the \code{R} package \code{Rmpfr}.
}
\details{
Suppose, for example, that we wish to find the Gauss quadrature nodes and weights
for the weight function \eqn{f} that is the probability density function of a random
variable with the same distribution as \eqn{R/m^{1/2}} where \eqn{R} has a
\eqn{\chi_m} distribution (i.e. \eqn{R^2} has a \eqn{\chi_m^2} distribution).
In this case, the \code{r}'th moment is
\deqn{\int_{-\infty}^{\infty} x^r f(x) dx
    = \left(\frac{2}{m} \right)^{r/2}
    \frac{\Gamma((r+m)/2)}{\Gamma(m/2)},}
which can be computed to an arbitrary number of bits of precision
\code{nbits} using the \code{R} package \code{Rmpfr}.
In this case, we specify this weight function \eqn{f} by first
assigning the value of \code{m} and then using the \code{R} command

\code{which.f <- list(name="scaled.chi.pdf", support=c(0, Inf), parameters=m)}

The code within the function \code{moments} used to compute the
\eqn{r}'th moment, to an arbitrary number of bits of precision
\code{nbits} using the package \code{Rmpfr}, is listed in the
Examples section.
}
\examples{
# The code for the function moments must include a section
# that computes the r th moment to an arbitrary number of bits
# of precision nbits using the R package Rmpfr for the particular
# weight function f of interest.
# Suppose that the weight function f is the probability density
# function of a random variable with the same probability
# distribution as R divided by the square root of m, where R has a
# chi distribution with m degrees of freedom.
# The code for the function moments includes the following:
#
#    if (which.f$name == "scaled.chi.pdf"){
#    m <- which.f$parameters
#    if (r == 0){
#    return(mpfr(1, nbits))
#    }
#    mp.2 <- mpfr(2, nbits)
#    mp.r <- mpfr(r, nbits)
#    mp.m <- mpfr(m, nbits)
#    term1 <- (mp.r/ mp.2) * log(mp.2 / mp.m)
#    term2 <- lgamma((mp.r + mp.m) / mp.2)
#    term3 <- lgamma(mp.m / mp.2)
#    return(exp(term1 + term2 - term3))
#    }

}
\seealso{
\code{custom}
}
