% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{asymptotic_test}
\alias{asymptotic_test}
\title{Asymptotic test for the equality of coefficients of variation from k populations, using measurement data}
\usage{
asymptotic_test(x, y, seed)
}
\arguments{
\item{x}{a numeric vector containing individual measurement values}

\item{y}{a vector of any type containing a grouping variable}

\item{seed}{optional, an integer that is the starting point used in the generation of a sequence of random numbers. Include a seed if you want reproducible output.}
}
\value{
a list with the test statistic and p-value
}
\description{
Test for k samples (k sample populations with unequal sized) from
Feltz CJ, Miller GE (1996) An asymptotic test for the equality of coefficients
of variation from k population. Stat Med 15:647–658
}
\examples{

 y <- unlist(lapply(letters[1:5], function(i) rep(i, 20)))
 x <- rnorm(100)

 asymptotic_test(x, y)

}
