% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/omkm.R
\name{omkm}
\alias{omkm}
\alias{omkmNrep}
\title{One-Mode K-Means Heuristic}
\usage{
omkm(A, RC, TLIMIT, IDIAG = 0)

omkmNrep(A, RC, REP, IDIAG = 0)
}
\arguments{
\item{A}{An \eqn{RO x RO} one-mode network matrix.}

\item{RC}{The number of clusters for row objects (\eqn{1 < RC < RO}).}

\item{TLIMIT}{A desired time limit.- for function \code{omkm} only.}

\item{IDIAG}{0 if main diagonal to be ignored, any other value it will be included. Default is 0.}

\item{REP}{The number of repetitions - for function \code{omkmNrep} only.}
}
\value{
The function returns the following:
\itemize{
\item \code{sse} - the sum of the within-block sum-of-squared deviations from the block means;
\item \code{vaf} - the variance-accounted-for;
\item \code{RP} - an \eqn{RO}-dimensional vector of row cluser assignements;
\item \code{restarts} - the number of restarts within the time limit.
}
}
\description{
This functions runs one-mode K-means for an \eqn{RO x RO} network matrix.
}
\examples{
# Load the notes borrowing data..
data("notesBorrowing")

#Run one-mode K-means procedure.
res <- omkm(notesBorrowing,RC = 3, TLIMIT = 1, IDIAG = 0)

# See the results.
res
}
\references{
Brusco, M. J., Doreian, P., & Steinley, D. (2019). Deterministic blockmodeling of signed and two-mode networks: a tutorial with psychological examples. \emph{British Journal of Mathematical and Statistical Psychology}.

Baier, D., Gaul, W., & Schader, M. (1997). Two-mode overlapping clustering with applications in simultaneous benefit segmentation and market structuring. In R. Klar & O. Opitz (Eds), \emph{Classification and knowledge organization} (pp. 557-566), Heidelberg: Springer.

Brusco, M., & Doreian, P. (2015). A real-coded genetic algorithm for two-mode KL-means partitioning with application to homogeneity blockmodeling. \emph{Social Networks}, 41, 26-35. http://dx.doi.org/10.1016/j.socnet.2014.11.007
Žiberna, A. (2020). K-means-based algorithm for blockmodeling linked networks. \emph{Social Networks}, 61, 153–169. https://doi.org/10.1016/j.socnet.2019.10.006
}
\author{
Michael Brusco
}
