% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mixture_plots.R
\name{mixture_plots}
\alias{mixture_plots}
\title{mixture_plots}
\usage{
mixture_plots(data)
}
\arguments{
\item{data}{An object resulting from a call to CUR when "mixture" is specified as cur_method.}
}
\value{
\code{mixture_plots} returns a list with the following plots:

\item{BIC}{BIC Plot of the Bayesian Information Criterion (BIC) for each number of mixture components. E and V stands for equal variance in mixture components or variable variance, respectively.}
\item{density}{leverages score's density}
\item{Cumulative}{cumulative density of leverages scores.}
\item{QQPlot}{Plot the sample quantiles and controlled quantiles of the inverse of the cumulative distribution function.}
}
\description{
This function returns different plots associated with the fitting of leverages scores through Mixture Gaussian Models.
}
\details{
Gaussian Mixture Models Plots
}
\examples{
\donttest{
results <- CUR(data=AASP, variables=hoessem:notabachillerato,
k=20, rows = .9999999, columns = .10, standardize = TRUE,
cur_method = "mixture")
mixture_plots(results)
}

}
\references{
\insertRef{Mahoney697}{dCUR}
\insertRef{villegas2018modelo}{dCUR}
\insertRef{dynamyCUR}{dCUR}
}
\seealso{
\code{\link[dCUR]{dCUR}}
\code{\link[dCUR]{CUR}}
}
\author{
Cesar Gamboa-Sanabria, Stefany Matarrita-Munoz, Katherine Barquero-Mejias, Greibin Villegas-Barahona, Mercedes Sanchez-Barba and Maria Purificacion Galindo-Villardon.
}
