% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core_tools.R
\name{check_discretization}
\alias{check_discretization}
\alias{check_discretization.drift_dm}
\alias{check_discretization.fits_ids_dm}
\alias{check_discretization.fits_agg_dm}
\title{Check time/space discretization via reference comparison}
\usage{
check_discretization(object, ...)

\method{check_discretization}{drift_dm}(
  object,
  ...,
  dt_ref = 0.001,
  dx_ref = 0.001,
  round_digits = 5
)

\method{check_discretization}{fits_ids_dm}(object, ...)

\method{check_discretization}{fits_agg_dm}(object, ...)
}
\arguments{
\item{object}{a \link{drift_dm}, \code{fits_agg_dm}, or \code{fits_ids_dm} object.
(the latter two are returned by \code{\link[=estimate_dm]{estimate_dm()}})}

\item{...}{further arguments passed forward to the respective method.}

\item{dt_ref, dx_ref}{numeric scalars, providing a fine time or space step
size for the reference solution. Defaults to \code{0.001}.}

\item{round_digits}{number of decimal places to which the final Hellinger
distances are rounded (default: \code{5}).}
}
\value{
a named numeric vector of Hellinger distances (one per condition)
if \code{object} is of type \link{drift_dm} or \code{fits_agg_dm}. A \link{data.frame}
of Hellinger distances across IDs and conditions if \code{object} is of type
\code{fits_ids_dm}. Hellinger distances are in \verb{[0, 1]}, where \code{0} means
identical to the reference.
}
\description{
\code{check_discretization()} helps you choose or check time (\code{dt}) and space
(\code{dx}) discretization settings. It computes a high-precision \emph{reference}
solution of the model's PDFs with \code{dt_ref}/\code{dx_ref}, and then compares the
reference PDFs to the discretization settings of the supplied object, using
the Hellinger distance per condition. Smaller distances indicate closer
agreement with the reference --- i.e., a sufficiently fine grid.

There are not yet overall and officially published recommendations on how
large the Hellinger distance can be without affecting model precision, and
this very likely will depend on the model itself. Based on some preliminary
simulations using \code{\link[=dmc_dm]{dmc_dm()}}, we would recommend trying to keep the
Hellinger Distance at best below 10 percent. However, we also observed for
extreme parameter values that the Hellinger distance can be even larger
without sacrificing the qualitative model behavior, and vice versa! It is
thus best to iterate between plotting model predictions and calculating the
Hellinger Distance, to ensure that you can best interpret this quantity for
your model at hand. Furthermore, we recommend to run parameter recoveries
using \code{\link[=simulate_data]{simulate_data()}} and \code{\link[=estimate_dm]{estimate_dm()}}, to check if
you can recover data generated under your model with fine discretization
using that same model with coarse discretization.
}
\details{
Under the hood, for each condition, we concatenate the lower- and upper-
boundary PDFs (\code{pdf_l}, \code{pdf_u}), interpolate the model PDFs to a time space
matching with the reference PDFs, and then compute the Hellinger distance:
\eqn{H(p,q) = \sqrt{1 - \int \sqrt{p(t)\,q(t)}\,dt}}

There are not yet overall, officially published recommendations on how large
the Hellinger distance can be without affecting model precision, and this may
even depend on the specific model. Based on preliminary simulations, we
recommend trying to keep the average Hellinger distance below 5\\%.

The reference discretizations (\code{dt_ref/dx_ref}) must be at least as fine as
the object's current discretization settings (\code{dt_model/dx_model}). If
\code{dt_model < dt_ref} or \code{dx_model < dx_ref}, an error is raised because the
“reference” would not be the finest solution.
}
\examples{
# Example:
my_model <- ratcliff_dm()

# Assess current (dt=0.0075, dx=0.02) against a fine reference:
check_discretization(my_model)

# If distances are near zero across conditions, the current grid is adequate.

}
\seealso{
\code{\link[=estimate_dm]{estimate_dm()}}, \code{\link[=trapz]{trapz()}}
}
