% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.run.eems.r
\name{gl.run.eems}
\alias{gl.run.eems}
\title{Runs the EEMS algorithm  (Estimating Effective Migration Surfaces) on a 
genlight object.}
\usage{
gl.run.eems(
  x,
  eems.path = "./",
  buffer = 10000,
  nDemes = 500,
  diploid = TRUE,
  numMCMCIter = 10000,
  numBurnIter = 2000,
  numThinIter = 9,
  seed = NULL,
  dpi = 250,
  add_grid = FALSE,
  col_grid = "#BBBBBB",
  add_demes = FALSE,
  col_demes = "#000000",
  add_outline = FALSE,
  col_outline = "#FFFFFF",
  eems_colors = NULL,
  plot.colors.pop = gl.colors("dis"),
  out.dir = NULL,
  plot.dir = NULL,
  plot.file = NULL,
  verbose = NULL,
  cleanup = TRUE,
  ...
)
}
\arguments{
\item{x}{Name of the genlight object containing the SNP data [required].}

\item{eems.path}{Path to the folder containing the eems executable
[default working directory ("./")].}

\item{buffer}{Buffer distance for all the elements [default 10000].}

\item{nDemes}{The approximate number of demes in the population graph 
[default 500].}

\item{diploid}{Whether the organism is diploid [default TRUE].}

\item{numMCMCIter}{Number of MCMC iterations [default 10000].}

\item{numBurnIter}{Number of burn-in iterations to discard at the start 
[default 2000].}

\item{numThinIter}{Number of iterations to thin between two writing steps
[default 9].}

\item{seed}{An integer used to seed the random number generator 
[default NULL].}

\item{dpi}{Resolution of the contour raster [default 250].}

\item{add_grid}{A logical value indicating whether to add the population 
grid or not [default FALSE].}

\item{col_grid}{The color of the population grid [default gray ("#BBBBBB")].}

\item{add_demes}{A logical value indicating whether to add the observed 
demes or not [default FALSE].}

\item{col_demes}{The color of the demes [default black ("#000000")].}

\item{add_outline}{A logical value indicating whether to add the habitat 
outline or not [default FALSE].}

\item{col_outline}{The color of the habitat outline 
[default white ("#FFFFFF")].}

\item{eems_colors}{The EEMS color scheme as a vector of colors, ordered 
from low to high [default NULL].}

\item{plot.colors.pop}{A color palette for population plots or a list with
as many colors as there are populations in the dataset
[default gl.colors("dis")].}

\item{out.dir}{Path where to save the output file. Use outpath=getwd() or 
out.dir='.' when calling this function to direct output files to your 
working or current directory [default tempdir(), mandated by CRAN].}

\item{plot.dir}{Directory to save the plot RDS files 
[default as specified by the global working directory or tempdir()].}

\item{plot.file}{Name for the RDS binary file to save (base name only, 
exclude extension) [default NULL].}

\item{verbose}{Verbosity: 0, silent or fatal errors; 1, begin and end; 2, 
progress log; 3, progress and results summary; 5, full report 
[default NULL, unless specified using gl.set.verbosity].}

\item{cleanup}{Whether to delete intermediate files [default TRUE].}

\item{...}{Extra parameters to add to function reemsplots2::make_eems_plots.}
}
\value{
A list of contour plots of migration and diversity rates as well as
several diagnostic plots. It is a good idea to examine all these figures,
which is why they are generated by default. Please check the examples how to
customise the figures.
\describe{
 \item{mrates01}{Effective migration surface. This contour plot visualises
  the estimated effective migration rates \code{m}, on the log10 scale after
   mean centering.}
 \item{mrates02}{Posterior probability contours \code{P(log(m) > 0) = p} 
 and \code{P(log(m) < 0) = p} for the given probability level \code{p}. 
 Since migration rates are visualised on the log10 scale after mean 
 centering, 0 corresponds to the overall mean migration rate. This contour 
 plot emphasizes regions with effective migration that is significantly 
 higher/lower than the overall average.}
 \item{qrates01}{Effective diversity surface. This contour plot visualises 
 the estimated effective diversity rates \code{q}, on the log10 scale after
  mean centering.}
 \item{qrates02}{Posterior probability contours \code{P(log(q) > 0) = p} 
 and \code{P(log(q) < 0) = p}. Similar to \code{mrates02} but applied to 
 the effective diversity rates.}
 \item{rdist01}{Scatter plot of the observed vs the fitted between-deme
  component of genetic dissimilarity, where one point represents a pair of 
  sampled demes.}
 \item{rdist02}{Scatter plot of the observed vs the fitted within-deme
  component of genetic dissimilarity, where one point represents a 
  sampled deme.}
 \item{rdist03}{Scatter plot of observed genetic dissimilarities between 
 demes vs observed geographic distances between demes.}
 \item{pilogl01}{Posterior probability trace}
}
}
\description{
This function runs the EEMS algorithm on a genlight object. The EEMS
 algorithm is a spatially explicit model that estimates effective migration 
 surfaces (EEMS) from genetic data. The EEMS algorithm is implemented in 
 C++, hence it is necessary to have the binary downloaded and the function 
 needs to point to this file via the path specified in eems.path. The binary
  is call runeems_snps[.exe] and can be downloaded from the github site of
   dartR.
}
\details{
Set the Number of MCMC iterations to 2 million for an initial run. If the 
posterior trace is still trending, lengthen the chain. Set the number of 
initial burnin iterations at 50% of total iterations. Set the iterations to 
thin between writes so that total/thin is around 100–200; a 10000‑step 
thinning interval is a practical default.

Choose the number of demes to match geographic scale: 100–250 for local or 
island studies and 300–500 for continental datasets. Runtime grows 
cubically with number of demes, so anything above 1000 rarely pays off. 

Draw the habitat polygon with a small buffer (in meters), so every sample 
sits at least one grid spacing inside the edge. A 5–10 % expansion of the 
sample bounding box (or a few kilometres for fine‑scale work) is usually 
adequate.

For plots, use a raster resolution of 600 dpi, this is publication‑quality. 
Drop to 300 dpi for quick diagnostics. Higher detail—higher resolution 
affects file size, not the inference itself.
}
\examples{
 \dontrun{
 # This example needs a binary (runeems_snps[.exe]) specific to your 
 # operating system  to run
 eems <- gl.run.eems(bandicoot.gl, eems.path = "d:/downloads/eems/")
 print(eems[[1]])
 }

}
\references{
\itemize{
\item Petkova D (2024). _reemsplots2: Generate plots to inspect and 
visualize the results of EEMS_. R package version 0.1.0,
\url{https://github.com/dipetkov/eems}.
\item 
D Petkova, J Novembre, M Stephens. Visualizing spatial population structure
with estimated effective migration surfaces. Nature Genetics 48, 
94 -- 100 (2016). \doi{10.1038/ng.3464}.
}
}
\author{
Bernd Gruber  & Robyn (bugs? Post to
\url{https://groups.google.com/d/forum/dartr})
}
