% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Deployment.R
\name{GetDeploymentAssociationId}
\alias{GetDeploymentAssociationId}
\alias{UpdateDeploymentAssociationId}
\title{Deployment Association ID}
\usage{
GetDeploymentAssociationId(deployment)

UpdateDeploymentAssociationId(
  deployment,
  columnNames = c(),
  requiredInPredictionRequests = NULL,
  maxWait = 600
)
}
\arguments{
\item{deployment}{An S3 object representing a model deployment, or the unique ID of such a
deployment.}

\item{columnNames}{character. Optional. Name(s) of the column(s) in your
dataset that will be used to map actuals to predictions and determine
accuracy. Note: This cannot be changed after the model has served
predictions and the API will return an error.}

\item{requiredInPredictionRequests}{logical. Optional. Whether the
association ID is required in a prediction request.}

\item{maxWait}{integer. How long to wait (in seconds) for the computation to
complete before returning a timeout error? (Default 600 seconds)}
}
\value{
An object classed \code{dataRobotDeploymentAssociationIdSettings}
that contains:
\describe{
\item{columnNames}{character. The columns that can be used as
association IDs.}
\item{requiredInPredictionRequests}{logical. Whether the association ID is
required in a prediction request.}
}
}
\description{
The association ID of a deployment is a foreign key for your prediction
dataset that will be used to match up actual values with those predictions.
The ID should correspond to an event for which you want to track the outcome.
}
\details{
These functions are convenience methods to get and set the association ID
settings for a deployment.
}
\section{Functions}{
\itemize{
\item \code{UpdateDeploymentAssociationId()}: Updates the association ID settings of
a deployment. It will only update those settings that correspond to set
arguments. This function will throw an error if the update fails and return
the updated settings on success.

}}
\seealso{
Other deployment accuracy functions: 
\code{\link{GetDeploymentAccuracyOverTime}()},
\code{\link{GetDeploymentAccuracy}()},
\code{\link{SubmitActuals}()}
}
\concept{deployment accuracy functions}
