% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/defined.R
\name{defined}
\alias{defined}
\alias{is.defined}
\alias{summary.haven_labelled_defined}
\title{Create a semantically enriched vector with variable-level metadata}
\usage{
defined(
  x,
  labels = NULL,
  label = NULL,
  unit = NULL,
  concept = NULL,
  namespace = NULL,
  ...
)

is.defined(x)

\method{summary}{haven_labelled_defined}(object, ...)
}
\arguments{
\item{x}{A vector to annotate.}

\item{labels}{Optional named vector of value labels. Only supported for
numeric or character vectors (not for logical).}

\item{label}{A short human-readable variable label (character of length 1).}

\item{unit}{Unit of measurement (character length 1) or \code{NULL}.}

\item{concept}{A URI or identifier describing the meaning or definition
of the variable. This replaces the deprecated \code{definition} argument.}

\item{namespace}{Optional string or named character vector used to generate
value-level URIs via substitution (\verb{$1} macro).}

\item{...}{For backward compatibility; the deprecated \code{definition}
argument is still accepted and mapped to \code{concept}.}

\item{object}{An R object to be summarised.}
}
\value{
A vector of class \code{"haven_labelled_defined"} or \code{"datetime_defined"},
depending on the input type.
}
\description{
\code{defined()} constructs a vector that behaves like a base R vector but carries
semantic metadata used for documentation, validation, and interoperability.
The resulting object inherits from \code{\link[haven:labelled]{haven::labelled()}} (for numeric,
character, and factor data) or from base date/time classes, and adds:
}
\details{
\itemize{
\item a human-readable variable label,
\item an optional unit of measurement,
\item a \strong{concept URI} identifying the meaning of the variable
(formerly called \emph{definition}),
\item an optional namespace used for value-level URI expansion,
\item optional labelled values (where supported).
}

The \code{concept} attribute is a general semantic anchor and may refer to:
a measure or dimension concept (SDMX-style), a property IRI (e.g. Wikibase),
or any URI that defines or describes the variable.

\code{defined()} vectors preserve their metadata during subsetting, printing,
summarizing, comparisons, and many tidyverse operations. They integrate
smoothly with \code{\link[=dataset_df]{dataset_df()}} objects and can be safely flattened via
\code{\link[=as.data.frame]{as.data.frame()}}, \code{\link[=as_tibble]{as_tibble()}}, or coercion helpers such as
\code{\link[=as_numeric]{as_numeric()}} and \code{\link[=as_character]{as_character()}}.
}
\section{Supported input types}{

\itemize{
\item numeric (integer or double)
\item character
\item factor (converted via \code{\link[labelled:to_labelled]{labelled::to_labelled()}})
\item \code{\link{Date}}
\item \code{\link{POSIXct}}
\item \code{\link[haven:labelled]{haven::labelled()}}
\item logical (with restrictions: logical vectors \strong{cannot} have value labels)
}
}

\examples{
gdp_vector <- defined(
  c(3897, 7365, 6753),
  label = "Gross Domestic Product",
  unit = "million dollars",
  concept = "http://data.europa.eu/83i/aa/GDP"
)

is.defined(gdp_vector)
print(gdp_vector)
summary(gdp_vector)
gdp_vector[1:2]

}
\seealso{
\code{\link[=is.defined]{is.defined()}},
\code{\link[=as_numeric]{as_numeric()}},
\code{\link[=as_character]{as_character()}},
\code{\link[=as_logical]{as_logical()}},
\code{\link[=strip_defined]{strip_defined()}},
\code{\link[=dataset_df]{dataset_df()}}
\code{\link[=print.haven_labelled_defined]{print.haven_labelled_defined()}}
}
