% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{mixMat}
\alias{mixMat}
\title{Combine two matrices}
\usage{
mixMat(mat1, mat2, lower = TRUE)
}
\arguments{
\item{mat1, mat2}{square matrices of the same dimensions.}

\item{lower}{a logical value indicating if the resulting matrix should be comprised of lower triangular matrices.}
}
\value{
A square matrix.
}
\description{
Creates a single matrix from two lower or upper triangular matrices.
}
\examples{
x <- matrix(1:16, 4)
y <- matrix(101:116, 4)
x[upper.tri(x, diag = TRUE)] <- NA
mixMat(x, y)

}
\seealso{
\code{\link{plotRel}} and \code{\link{plotColorbar}} for plotting
relatedness estimates.
}
