% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layers_grid-cell-layer.R
\name{add_grid_cell_layer}
\alias{add_grid_cell_layer}
\title{Add a grid cell layer to the deckgl widget}
\usage{
add_grid_cell_layer(
  deckgl,
  data = NULL,
  properties = list(),
  ...,
  id = "grid-cell-layer"
)
}
\arguments{
\item{deckgl}{A deckgl widget object.}

\item{data}{The url to fetch data from or a data object.}

\item{properties}{A named list of properties with names corresponding to the properties defined
in the \href{https://deck.gl/#/documentation/deckgl-api-reference}{deckgl-api-reference}
for the given layer class. The \code{properties} parameter can also be an empty list. In this case
all props must be passed as named arguments.}

\item{...}{Named arguments that will be added to the \code{properties} object. Identical parameters
are overwritten.}

\item{id}{The unique id of the layer.}
}
\description{
The \code{GridCellLayer} can render a grid-based heatmap.
It is a variation of the \code{ColumnLayer}. It takes the constant width / height of all cells and top-left coordinate of each cell.
The grid cells can be given a height using the \code{getElevation} accessor.
}
\examples{
hexagon_centroids <- system.file("sample-data/centroids.csv", package = "deckgl") \%>\%
  read.csv()

deck <- deckgl(zoom = 11, pitch = 35) \%>\%
  add_grid_cell_layer(
    data = hexagon_centroids,
    getPosition = ~lng + lat,
    getElevation = ~value,
    getFillColor = "@=[48, 128, value * 255, 255]",
    elevationScale = 5000,
    cellSize = 250,
    extruded = TRUE,
    tooltip = "{{value}}"
  ) \%>\%
  add_mapbox_basemap()

if (interactive()) deck
}
\seealso{
\url{https://deck.gl/#/documentation/deckgl-api-reference/layers/grid-cell-layer}
}
