#' @importFrom VMDecomp vmd
#' @importFrom forecast nnetar forecast
#' @importFrom utils head tail
#' @importFrom graphics plot
#' @importFrom stats as.ts ts
#' @export
#'

vmdARIMA <- function(data, stepahead=10, nIMF=4, alpha=2000, tau=0, D=FALSE)
{
  data <- ts(data)
  data<- as.vector(data)
  v<- vmd(data , alpha=2000, tau=0, K=nIMF, DC=D, init=1, tol = 1e-6)
  AllIMF<-v$u
  data_trn <- ts(head(data, round(length(data) - stepahead)))
  data_test <- ts(tail(data, stepahead))
  IMF_trn <- AllIMF[-c(((length(data) - stepahead) + 1):length(data)),
  ]
  Fcast_AllIMF <- NULL
  for (AllIMF in 1:(ncol(IMF_trn))) {
    IndIMF <- NULL
    IndIMF <- IMF_trn[, AllIMF]
    vmdARIMAFit <- forecast::auto.arima(as.ts(IndIMF))
    vmdARIMA_fcast = forecast::forecast(vmdARIMAFit, h = stepahead)
    vmdARIMA_fcast_Mean = vmdARIMA_fcast$mean
    Fcast_AllIMF <- cbind(Fcast_AllIMF, as.matrix(vmdARIMA_fcast_Mean))
  }
  FinalvmdARIMA_fcast <- ts(rowSums(Fcast_AllIMF, na.rm = T))
  MAE_vmdARIMA = mean(abs(data_test - FinalvmdARIMA_fcast))
  MAPE_vmdARIMA = mean(abs(data_test - FinalvmdARIMA_fcast)/data_test)
  RMSE_vmdARIMA = sqrt(mean((data_test - FinalvmdARIMA_fcast)^2))
  return(list(AllIMF = AllIMF, data_test = data_test,
              AllIMF_forecast = Fcast_AllIMF, FinalvmdARIMA_forecast = FinalvmdARIMA_fcast,
              MAE_vmdARIMA = MAE_vmdARIMA, MAPE_vmdARIMA = MAPE_vmdARIMA,
              RMSE_vmdARIMA = RMSE_vmdARIMA ))
}
