#' Eon data from the International Commission on Stratigraphy (v2024/12)
#'
#' A dataset containing the boundary ages, abbreviations, and colors for the
#' eons of the Geologic Time Scale. Based on The ICS International
#' Chronostratigraphic Chart (v2024/12), by Cohen, Finney, Gibbard, and Fan.
#'
#' @format A data frame with 3 rows and 5 variables:
#' \describe{
#'   \item{name}{eon name}
#'   \item{max_age}{maximum age, in millions of years}
#'   \item{min_age}{minimum age, in millions of years}
#'   \item{abbr}{eon name abbreviations}
#'   \item{color}{the colors for each eon, according to the Commission for the
#'     Geological Map of the World}
#'   \item{lab_color}{the label colors for each eon, either white or black,
#'     whichever has better contrast with the background color, based on
#'     [recommendations by the International Telecommunication Union](https://www.itu.int/rec/R-REC-BT.601-7-201103-I/en)}
#' }
#' @family built-in timescales
#' @source <https://stratigraphy.org> via <https://macrostrat.org/api/v2/defs/intervals?timescale=international%20eons>
"eons"

#' Era data from the International Commission on Stratigraphy (v2024/12)
#'
#' A dataset containing the boundary ages, abbreviations, and colors for the
#' eras of the Geologic Time Scale. Based on The ICS International
#' Chronostratigraphic Chart (v2024/12), by Cohen, Finney, Gibbard, and Fan.
#'
#' @format A data frame with 10 rows and 5 variables:
#' \describe{
#'   \item{name}{era name}
#'   \item{max_age}{maximum age, in millions of years}
#'   \item{min_age}{minimum age, in millions of years}
#'   \item{abbr}{era name abbreviations}
#'   \item{color}{the colors for each era, according to the Commission for the
#'     Geological Map of the World}
#'   \item{lab_color}{the label colors for each era, either white or black,
#'     whichever has better contrast with the background color, based on
#'     [recommendations by the International Telecommunication Union](https://www.itu.int/rec/R-REC-BT.601-7-201103-I/en)}
#' }
#' @family built-in timescales
#' @source <https://stratigraphy.org> via <https://macrostrat.org/api/v2/defs/intervals?timescale=international%20eras>
"eras"

#' Period data from the International Commission on Stratigraphy (v2024/12)
#'
#' A dataset containing the boundary ages, abbreviations, and colors for the
#' periods of the Geologic Time Scale. Based on The ICS International
#' Chronostratigraphic Chart (v2024/12), by Cohen, Finney, Gibbard, and Fan.
#'
#' @format A data frame with 22 rows and 5 variables:
#' \describe{
#'   \item{name}{period name}
#'   \item{max_age}{maximum age, in millions of years}
#'   \item{min_age}{minimum age, in millions of years}
#'   \item{abbr}{period name abbreviations}
#'   \item{color}{the colors for each period, according to the Commission for
#'     the Geological Map of the World}
#'   \item{lab_color}{the label colors for each period, either white or black,
#'     whichever has better contrast with the background color, based on
#'     [recommendations by the International Telecommunication Union](https://www.itu.int/rec/R-REC-BT.601-7-201103-I/en)}
#' }
#' @family built-in timescales
#' @source <https://stratigraphy.org> via <https://macrostrat.org/api/v2/defs/intervals?timescale=international%20periods>
"periods"

#' Epoch data from the International Commission on Stratigraphy (v2024/12)
#'
#' A dataset containing the boundary ages, abbreviations, and colors for the
#' epochs of the Geologic Time Scale. Based on The ICS International
#' Chronostratigraphic Chart (v2024/12), by Cohen, Finney, Gibbard, and Fan.
#'
#' @format A data frame with 34 rows and 5 variables:
#' \describe{
#'   \item{name}{epoch name}
#'   \item{max_age}{maximum age, in millions of years}
#'   \item{min_age}{minimum age, in millions of years}
#'   \item{abbr}{epoch name abbreviations}
#'   \item{color}{the colors for each epoch, according to the Commission for the
#'     Geological Map of the World}
#'   \item{lab_color}{the label colors for each epoch, either white or black,
#'     whichever has better contrast with the background color, based on
#'     [recommendations by the International Telecommunication Union](https://www.itu.int/rec/R-REC-BT.601-7-201103-I/en)}
#' }
#' @family built-in timescales
#' @source <https://stratigraphy.org> via <https://macrostrat.org/api/v2/defs/intervals?timescale=international%20epochs>
"epochs"

#' Stage data from the International Commission on Stratigraphy (v2024/12)
#'
#' A dataset containing the boundary ages, abbreviations, and colors for the
#' stages of the Geologic Time Scale. Based on The ICS International
#' Chronostratigraphic Chart (v2024/12), by Cohen, Finney, Gibbard, and Fan.
#'
#' @format A data frame with 102 rows and 5 variables:
#' \describe{
#'   \item{name}{stage name}
#'   \item{max_age}{maximum age, in millions of years}
#'   \item{min_age}{minimum age, in millions of years}
#'   \item{abbr}{stage name abbreviations}
#'   \item{color}{the colors for each stage, according to the Commission for the
#'     Geological Map of the World}
#'   \item{lab_color}{the label colors for each stage, either white or black,
#'     whichever has better contrast with the background color, based on
#'     [recommendations by the International Telecommunication Union](https://www.itu.int/rec/R-REC-BT.601-7-201103-I/en)}
#' }
#' @family built-in timescales
#' @source <https://stratigraphy.org> via <https://macrostrat.org/api/v2/defs/intervals?timescale=international%20ages>
"stages"

#' Pattern numbers and names for patterns from the FGDC Digital Cartographic
#' Standard for Geologic Map Symbolization
#'
#' A dataset containing the FGDC pattern numbers and verbatim names from the
#' [FGDC Digital Cartographic Standard for Geologic Map
#' Symbolization](https://ngmdb.usgs.gov/fgdc_gds/geolsymstd.php) by the [U.S.
#' Geological Survey](https://www.usgs.gov/) and the [Geologic Data Subcommittee
#' (GDS)](https://ngmdb.usgs.gov/fgdc_gds/index.php) of the [Federal Geographic
#' Data Committee (FGDC)](https://www.fgdc.gov/). Only patterns with names are
#' included (i.e., patterns 601-733).
#'
#' These pattern numbers and names were originally extracted by Daven Quinn and
#' are hosted on [GitHub](https://github.com/davenquinn/geologic-patterns/).
#'
#' @format A data frame with 117 rows and 2 variables:
#' \describe{
#'   \item{code}{the pattern number according to the FGDC standard}
#'   \item{name}{the verbatim name for the pattern according to the FGDC standard}
#' }
#' @family patterns
#' @source
#'   <https://ngmdb.usgs.gov/fgdc_gds/geolsymstd/fgdc-geolsym-patternchart.pdf>
#'   via <https://github.com/davenquinn/geologic-patterns/>
"fgdc_names"
