% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/default.R
\name{default}
\alias{default}
\alias{default<-}
\alias{reset_default}
\title{change a function's default arguments}
\usage{
default(fun)

default(fun) <- value

reset_default(fun)
}
\arguments{
\item{fun}{a function}

\item{value}{a named list of new default arguments for that function}
}
\value{
\code{default()} (without assignment) invisibly returns a pairlist of
  the current values of the default arguments. It also prints the default
  arguments, highlighting those that the user has changed from their original
  defaults.

  \code{reset_default()} returns the \code{fun}, but with the defaults reset
  to their original values. If \code{fun} was a function from a package, the
  same thing can be achieved by replacing the locally-defined version of the
  function.
}
\description{
\code{default()} lets you check, and change, a function's
  default arguments. \code{reset_default()} returns the arguments to their
  original defaults.
}
\details{
If \code{fun} is a function from a package, a function of the same
  name will be defined in the calling environment (e.g. your workspace).
  If \code{fun} is defined locally, it will be overwritten by the version
  with the new defaults.

  \code{reset_default} \emph{returns} the reset function, rather than
  modifying it in place, so you'll need to reassign it, as in the example.
}
\examples{
# list the default arguments for a function
default(data.frame)

# change one or more of them
default(data.frame) <- list(fix.empty.names = FALSE)
data.frame(1:3)

# reset the defaults
data.frame <- reset_default(data.frame)
data.frame(1:3)
}
