% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deltaccd.R
\name{calcCCD}
\alias{calcCCD}
\title{Calculate clock correlation distance (CCD).}
\usage{
calcCCD(
  refCor,
  emat,
  groupVec = NULL,
  refEmat = NULL,
  nPerm = 1000,
  geneNames = NULL,
  dopar = FALSE,
  scale = FALSE
)
}
\arguments{
\item{refCor}{Correlation matrix to be used as the reference, such as comes
from \code{\link[=getRefCor]{getRefCor()}}. Should contain Spearman correlation values.}

\item{emat}{Matrix of expression values, where each row corresponds to a
gene and each column corresponds to a sample. The rownames and colnames of
\code{refCor} should be present in the rownames of \code{emat}. For the p-value
calculation, it is important that \code{emat} include all measured genes, not
just those in \code{refCor}.}

\item{groupVec}{Optional vector indicating the group to which group each
sample belongs. If not provided, the function assumes all samples belong to
the same group.}

\item{refEmat}{Optional expression matrix for calculating co-expression for
the reference, with the same organization as \code{emat}. Only used if \code{refCor}
is not provided.}

\item{nPerm}{Number of permutations for assessing statistical significance.}

\item{geneNames}{Optional vector indicating a subset of genes in \code{refCor},
\code{emat}, and/or \code{refEmat} to use for calculating the CCD.}

\item{dopar}{Logical indicating whether to process features in parallel. Make
sure to register a parallel backend first.}

\item{scale}{Logical indicating whether to scale CCD by the number of gene
pairs.}
}
\value{
A data.table with columns for group name, CCD, and p-value.
}
\description{
Quantify the similarity of gene co-expression between a reference and a test
dataset. Statistical significance is calculated using permutation of the
genes.
}
\examples{
set.seed(35813)

refCor = getRefCor()
ccdResult = calcCCD(refCor, GSE19188$emat, GSE19188$groupVec, nPerm = 100)

}
\seealso{
\code{\link[=getRefCor]{getRefCor()}}, \code{\link[=calcDeltaCCD]{calcDeltaCCD()}}, \code{\link[=plotHeatmap]{plotHeatmap()}}
}
