% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deltaccd.R
\name{getRefCor}
\alias{getRefCor}
\title{Retrieve the reference correlation matrix for circadian gene co-expression.}
\usage{
getRefCor(
  species = c("human", "mouse"),
  tissue = c("pan", "blood"),
  useEntrezGeneId = TRUE
)
}
\arguments{
\item{species}{Currently either 'human' or 'mouse'. Only affects the row and
column names of the correlation matrix, not the actual values.}

\item{tissue}{One of either 'pan' or 'blood'.}

\item{useEntrezGeneId}{If \code{FALSE}, row and column names of correlation matrix
will correspond to gene symbols (e.g., PER2).}
}
\value{
A matrix of Spearman correlation values.
}
\description{
The pan-tissue reference matrix is based on a fixed-effects meta-analysis of
eight circadian transcriptome datasets from mice, as described in
Shilts et al. 2018(\doi{https://doi.org/10.7717/peerj.4327}). The human blood
reference matrix is based an analysis of three microarray datasets
(manuscript in preparation).
}
\seealso{
\link{GSE19188}, \code{\link[=plotRefHeatmap]{plotRefHeatmap()}}, \code{\link[=calcCCD]{calcCCD()}}, \code{\link[=calcDeltaCCD]{calcDeltaCCD()}}
}
