% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mle_nb.r
\name{mle_nb}
\alias{mle_nb}
\alias{mle_nb_null}
\alias{mle_nb_alt}
\title{MLE for NB}
\usage{
mle_nb_null(
  data,
  equal_dispersion = FALSE,
  ratio_null = 1,
  method = "nlm_constrained",
  ...
)

mle_nb_alt(data, equal_dispersion = FALSE, method = "nlm_constrained", ...)
}
\arguments{
\item{data}{(list)\cr
A list whose first element is the vector of negative binomial values
from group 1 and the second element is the vector of negative binomial
values from group 2.
\link[base]{NA}s are silently excluded. The default output from
\code{\link[=sim_nb]{sim_nb()}}.}

\item{equal_dispersion}{(Scalar logical: \code{FALSE})\cr
If \code{TRUE}, the MLEs are calculated assuming both groups have the same
population dispersion parameter. If \code{FALSE} (default), the MLEs are
calculated assuming different dispersions.}

\item{ratio_null}{(Scalar numeric: \code{1}; \verb{(0, Inf)})\cr
The ratio of means assumed under the null hypothesis (group 2 / group 1).
Typically \code{ratio_null = 1} (no difference).}

\item{method}{(string: \code{"nlm_constrained"})\cr
The optimization method. Must choose one of \code{"nlm"},
\code{"nlm_constrained"}, \code{"optim"}, or \code{"optim_constrained"}. The default
bounds for constrained optimization are \verb{[1e-03, 1e06]}.}

\item{...}{Optional arguments passed to the optimization method.}
}
\value{
\itemize{
\item For \code{mle_nb_alt()}, a list with the following elements:
\tabular{lll}{
Slot \tab Name \tab Description \cr
1 \tab \code{mean1} \tab MLE for mean of group 1. \cr
2 \tab \code{mean2} \tab MLE for mean of group 2. \cr
3 \tab \code{ratio} \tab MLE for ratio of means. \cr
4 \tab \code{dispersion1} \tab MLE for dispersion of group 1. \cr
5 \tab \code{dispersion2} \tab MLE for dispersion of group 2. \cr
6 \tab \code{equal_dispersion} \tab Were equal dispersions assumed. \cr
7 \tab \code{n1} \tab Sample size of group 1. \cr
8 \tab \code{n2} \tab Sample size of group 2. \cr
9 \tab \code{nll} \tab Minimum of negative log-likelihood. \cr
10 \tab \code{nparams} \tab Number of estimated parameters. \cr
11 \tab \code{method} \tab Method used for the results. \cr
12 \tab \code{mle_method} \tab Method used for optimization. \cr
13 \tab \code{mle_code} \tab Integer indicating why the optimization process terminated. \cr
14 \tab \code{mle_message} \tab Additional information from the optimizer.
}
\item For \code{mle_nb_null()}, a list with the following elements:
\tabular{lll}{
Slot \tab Name \tab Description \cr
1 \tab \code{mean1} \tab MLE for mean of group 1. \cr
2 \tab \code{mean2} \tab MLE for mean of group 2. \cr
3 \tab \code{ratio_null} \tab Population ratio of means assumed for null hypothesis.
\code{mean2 = mean1 * ratio_null}. \cr
4 \tab \code{dispersion1} \tab MLE for dispersion of group 1. \cr
5 \tab \code{dispersion2} \tab MLE for dispersion of group 2. \cr
6 \tab \code{equal_dispersion} \tab Were equal dispersions assumed. \cr
7 \tab \code{n1} \tab Sample size of group 1. \cr
8 \tab \code{n2} \tab Sample size of group 2. \cr
9 \tab \code{nll} \tab Minimum of negative log-likelihood. \cr
10 \tab \code{nparams} \tab Number of estimated parameters. \cr
11 \tab \code{method} \tab Method used for the results. \cr
12 \tab \code{mle_method} \tab Method used for optimization. \cr
13 \tab \code{mle_code} \tab Integer indicating why the optimization process terminated. \cr
14 \tab \code{mle_message} \tab Additional information from the optimizer.
}
}
}
\description{
Maximum likelihood estimates (MLE) for two independent negative binomial
outcomes.
}
\details{
These functions are primarily designed for speed in simulation. Missing values
are silently excluded.

Suppose \eqn{X_1 \sim \text{NB}(\mu, \theta_1)} and
\eqn{X_2 \sim \text{NB}(r\mu, \theta_2)}, where \eqn{X_1} and \eqn{X_2} are
independent, \eqn{X_1} is the count outcome for items in group 1, \eqn{X_2}
is the count outcome for items in group 2, \eqn{\mu} is the arithmetic mean
count in group 1, \eqn{r} is the ratio of arithmetic means for group 2 with
respect to group 1, \eqn{\theta_1} is the dispersion parameter of group 1,
and \eqn{\theta_2} is the dispersion parameter of group 2.

The MLEs of \eqn{r} and \eqn{\mu} are \eqn{\hat{r} = \frac{\bar{x}_2}{\bar{x}_1}}
and \eqn{\hat{\mu} = \bar{x}_1}. The MLEs of \eqn{\theta_1} and \eqn{\theta_2}
are found by maximizing the profile log-likelihood
\eqn{l(\hat{r}, \hat{\mu}, \theta_1, \theta_2)} with respect to
\eqn{\theta_1} and \eqn{\theta_2}. When \eqn{r = r_{null}} is known, the MLE
of \eqn{\mu} is
\eqn{\tilde{\mu} = \frac{n_1 \bar{x}_1 + n_2 \bar{x}_2}{n_1 + n_2}} and
\eqn{\tilde{\theta}_1} and \eqn{\tilde{\theta}_2} are obtained by maximizing
the profile log-likelihood \eqn{l(r_{null}, \tilde{\mu}, \theta_1, \theta_2)}.

The backend method for numerical optimization is controlled by argument
\code{method} which refers to \code{\link[stats:nlm]{stats::nlm()}}, \code{\link[stats:nlminb]{stats::nlminb()}}, or
\code{\link[stats:optim]{stats::optim()}}. If you would like to see warnings from the optimizer,
include argument \code{warnings = TRUE}.
}
\examples{
#----------------------------------------------------------------------------
# mle_nb() examples
#----------------------------------------------------------------------------
library(depower)

d <- sim_nb(
  n1 = 60,
  n2 = 40,
  mean1 = 10,
  ratio = 1.5,
  dispersion1 = 2,
  dispersion2 = 8
)

mle_alt <- d |>
  mle_nb_alt()

mle_null <- d |>
  mle_nb_null()

mle_alt
mle_null

}
\references{
\insertRef{rettiganti_2012}{depower}

\insertRef{aban_2009}{depower}
}
\seealso{
\code{\link[=sim_nb]{sim_nb()}}, \link{nll_nb}
}
