% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/descstat.R
\docType{package}
\name{descstat-package}
\alias{descstat-package}
\title{descstat: a toolbox for descriptive statistics}
\description{
Descriptive statistics consist on presenting the distribution of
series for a sample in tables (frequency table for one series,
contingency tables for two series), ploting this distribution and
computing some statistics that summarise it. \strong{descstat} provides
a complete toolbox to perform this tasks. It has been writen using
some packages of the tidyverse (especially \strong{dplyr}, \strong{tidyr} and
\strong{purrr}) and its usage follow the tidyverse conventions,
especially the selection of series using their unquoted names and
the use of the pipe operator and of tibbles.
}
\section{The bin class}{


In a frequency (or contingency table), continuous numerical series
are presented as bins. Moreover, for some surveys, the individual
values are not known, but only the fact that these values belongs to
a bin. Therefore, it is crucial to be able to work easily with
bins, ie:
\itemize{
\item creating bins from numerical values, which is performed by the
\code{base::cut} function which turns a numerical series to a bin,
\item coercing bins to numerical values, eg getting from the \verb{[10,20)}
bin the lower bound (10), the upper bound (20), the center (15) or
whatever other value of the bin,
\item reducing the number of bins by merging some of them (for example
\verb{[0,10)}, \verb{[10, 20)}, \verb{[20,30)}, \verb{[30,Inf)} to \verb{[0,20)}, \verb{[20,Inf)}
}

these latter two tasks are performed using the new \code{bin} class
provided by this package and the accompanying \code{as_numeric} function
for the coercion to numeric and the \code{cut} method for bins
merging. Especially, coercing bins to their center values is the
basis of the computation of descripting statistics for bins.
}

\section{Frequency and contingency tables}{


The \code{freq_table} and \code{cont_table} are based on the \code{dplyr::count}
function but offer a much richer interface and performs easily
usual operations which are tedious to obtain with \code{dplyr::count} or
\code{base::table} functions. This includes:
\itemize{
\item adding a total,
\item for frequency tables, computing other kind of frequencies than
the counts, for example relative frequencies, percentage,
cummulative frequencies, etc.,
\item for contingency tables, computing easily the joint, marginal and
conditional distributions,
\item printing easily the contingency table as a double entry table.
}
}

\section{Plotting the distribution}{


A \code{pre_plot} function is provided to put the tibble in form in
order to use classic plots for univariate or bivariate
distributions. This includes histogram, frequency plot, pie chart,
cummulative plot and Lorenz curve. The final plot can then be
obtained using some geoms of \strong{ggplot2}.
}

\section{Descriptive statistics}{


A full set of statistical functions (of central tendency,
dispersion, shape, concentration and covariation) are provided and
can be applied directly on objects of class \code{freq_table} or
\code{cont_table}. Some of them are methods of generics defined by the
\code{base} or \code{stats} package, some other are defined as methods for
generics function provided by the \strong{descstat} function when the
corresponding \strong{R} function is not generic. For example,
\itemize{
\item \code{mean} is generic, so that we wrote a
\code{mean.freq_table} method to compute directly the mean of a series
from a frequency table.
\item \code{var} is not generic, so that we provide the \code{variance} generic
and a method for \code{freq_table} objects.
}
}

\keyword{package}
