% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print_methods.R
\name{print_method}
\alias{print_method}
\alias{pre_print}
\alias{pre_print.freq_table}
\alias{pre_print.cont_table}
\alias{format.freq_table}
\alias{format.cont_table}
\alias{print.cont_table}
\alias{print.bin}
\title{Print methods for bin, freq_table and cont_table objects}
\usage{
pre_print(x, ...)

\method{pre_print}{freq_table}(x, ...)

\method{pre_print}{cont_table}(x, ..., row_name = TRUE, total_name = "Total")

\method{format}{freq_table}(x, ..., n = NULL, width = NULL, n_extra = NULL)

\method{format}{cont_table}(
  x,
  ...,
  n = NULL,
  width = NULL,
  n_extra = NULL,
  row_name = TRUE,
  total_name = "Total"
)

\method{print}{cont_table}(
  x,
  ...,
  n = NULL,
  width = NULL,
  n_extra = NULL,
  row_name = TRUE,
  total_name = "Total"
)

\method{print}{bin}(x, ...)
}
\arguments{
\item{x}{a \code{bin}, a \code{freq_table} or a \code{cont_table} object,}

\item{...}{further arguments,}

\item{row_name}{a logical that indicates whether the first column
in the two-ways contingency table, that contains the levels of
the first series, should be named,}

\item{total_name}{the name of the line (and of the column for
\code{cont_table}) that contains the total (default is \code{"Total"}),}

\item{n, width, n_extra}{see \link[tibble:formatting]{tibble::formatting} and
\link[tibble:formatting]{tibble::formatting}.}
}
\value{
a tibble, for the \code{cont_table} it is a tibble in wide
format as the \code{cont_table} object is in long format.
}
\description{
\code{freq_table} and \code{cont_table} are tibbles with specific format and
print methods for pretty printing. A \code{pre_print} generic is
provided with specific methods to put in form \code{freq_table} and
\code{cont_table} objects.
}
\keyword{print}
