% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/descsuppR-package.r
\name{calc_descr_long}
\alias{calc_descr_long}
\title{calc_descr_long}
\usage{
calc_descr_long(
  x,
  xname,
  extraLevels = NULL,
  includeNAs = FALSE,
  includeNonNAs = FALSE,
  orderedAsUnordered = FALSE,
  factorlevellimit = 14,
  show.minmax = TRUE,
  show.IQR = FALSE,
  sd_digits = "by_mean",
  descr_digits = 2,
  significant_digits = TRUE
)
}
\arguments{
\item{x}{vector of which to calc the descriptive values}

\item{xname}{the name of the variable encoded in x}

\item{extraLevels}{named list of lists.  Names have to be variable names.  Elements have to have to be named list of this form: \code{`some label` = list(idxvec = idxvec, display = logical)}.  Here \code{idxvec} needs to be a logical vector of length \code{nrow(df)} that specifies the affected rows.  If \code{display} is \code{TRUE} the number of affected rows will be shown under \code{some label}.}

\item{includeNAs}{logical. include the number of NAs in the output?}

\item{orderedAsUnordered}{logical. treat ordered factors as
unordered factors?}

\item{factorlevellimit}{integer.  for factors with more than
\code{factorlevellimit} levels, not all levels are printed}

\item{show.minmax}{logical. if TRUE show minimum and maximum for numeric variables.  Defaults to \code{TRUE}.}

\item{show.IQR}{logical. if TRUE show 25\% and 75\% quantiles for numeric variables.  Defaults to \code{FALSE}.}

\item{sd_digits}{character.  one of c("by_mean", "fixed").  If 'by_mean', the number of decimal places of the standard deviation is limited by the number of decimal places of the mean.}

\item{descr_digits}{integer. Number of digits for formatting of descriptive values. Defaults to 2.}

\item{significant_digits}{boolean.  if TRUE, the number of significant digits of is given by descr_digits. Otherwise the number of decimal places is fixed.}
}
\value{
data.frame of character describing x
}
\description{
change the description into the long format
}
\details{
only for internal use.
}
\author{
Andreas Leha
}
\keyword{internal}
