% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shuffle_samples.R
\name{complete_random_shuffling}
\alias{complete_random_shuffling}
\title{Reshuffle sample indices completely randomly}
\usage{
complete_random_shuffling(batch_container, ...)
}
\arguments{
\item{batch_container}{The batch-container.}

\item{...}{Other params that are passed to a generic shuffling function (like the iteration number).}
}
\value{
A random permutation of the sample assignment in the container.
}
\description{
This function was just added to test early on the functionality of optimize_design() to accept a
permutation vector rather than a list with src and dst indices.
}
\examples{
data("invivo_study_samples")
bc <- BatchContainer$new(
  dimensions = c("plate" = 2, "column" = 5, "row" = 6)
)
scoring_f <- osat_score_generator("plate", "Sex")
bc <- optimize_design(
  bc, scoring = scoring_f, invivo_study_samples,
  max_iter = 100,
  shuffle_proposal_func = complete_random_shuffling
)
}
