% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shuffle_samples.R
\name{mk_swapping_function}
\alias{mk_swapping_function}
\title{Create function to propose swaps of samples on each call, either with a constant number of swaps or following
a user defined protocol}
\usage{
mk_swapping_function(n_swaps = 1)
}
\arguments{
\item{n_swaps}{Vector with number of swaps to be proposed in successive calls to the returned function (each value should be in valid range from 1..\code{floor(n_samples/2)})}
}
\value{
Function to return a list with length n vectors \code{src} and \code{dst}, denoting source and destination index for the swap operation, or NULL if the user provided a defined protocol for the number of swaps and the last iteration has been reached.
}
\description{
If \code{length(n_swaps)==1}, the returned function may be called an arbitrary number of times.
If \code{length(n_swaps)>1} and called without argument, the returned function may be called length(n_swaps) timed before returning NULL, which would be the stopping criterion if all requested swaps have been exhausted. Alternatively, the function may be called with an iteration number as the only argument, giving the user some freedom how to iterate over the sample swapping protocol.
}
\examples{
data("invivo_study_samples")
bc <- BatchContainer$new(
  dimensions = c("plate" = 2, "column" = 5, "row" = 6)
)
scoring_f <- osat_score_generator("plate", "Sex")
optimize_design(
  bc, scoring = scoring_f, invivo_study_samples,
  max_iter = 100,
  shuffle_proposal_func = mk_swapping_function(1)
)
}
