% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assignment.R
\name{shuffle_with_constraints}
\alias{shuffle_with_constraints}
\title{Shuffling proposal function with constraints.}
\usage{
shuffle_with_constraints(src = TRUE, dst = TRUE)
}
\arguments{
\item{src}{Expression to define possible source locations in the samples/locations
table. Usually evaluated based on
\code{BatchContainer$get_samples(include_id = TRUE, as_tibble = FALSE)} as an environment
(see also \code{with()}). A single source location is selected from rows where the
expression evaluates to\code{TRUE}.}

\item{dst}{Expression to define possible destination locations in the
samples/locations table. Usually evaluated based on \code{BatchContainer$get_samples()} as an
environment.
Additionally a special variable \code{.src} is available in this environment which
describes the selected source row from the table.}
}
\value{
Returns a function which accepts a \code{BatchContainer} and an iteration
number (\code{i}). This function returns a list with two names: \code{src} vector of length
2 and \code{dst} vector of length two. See \code{\link[=BatchContainer]{BatchContainer$move_samples()}}.
}
\description{
Can be used with \code{optimize_design} to improve convergence speed.
}
\examples{
set.seed(43)

samples <- data.frame(
  id = 1:100,
  sex = sample(c("F", "M"), 100, replace = TRUE),
  group = sample(c("treatment", "control"), 100, replace = TRUE)
)

bc <- BatchContainer$new(
  dimensions = c("plate" = 5, "position" = 25)
)

scoring_f <- function(samples) {
  osat_score(
    samples,
    "plate",
    c("sex", "group")
  )$score
}

# in this example we treat all the positions in the plate as equal.
# when shuffling we enforce that source location is non-empty,
# and destination location has a different plate number
bc <- optimize_design(
  bc,
  scoring = scoring_f,
  samples,
  shuffle_proposal = shuffle_with_constraints(
    # source is non-empty location
    !is.na(.sample_id),
    # destination has a different plate
    plate != .src$plate
  ),
  max_iter = 10
)
}
