test_that("$get_samles(as_tibble=TRUE) returns correct columns & expected number of rows", {
  bc <- BatchContainer$new(
    dimensions = c(row = 3, column = 3)
  )
  samp <- data.frame(i = 1:8)
  expect_error(bc$get_samples())
  bc$samples <- samp
  bc <- assign_in_order(bc)
  stab <- bc$get_samples()
  expect_true(tibble::is_tibble(stab))
  expect_named(stab, c("row", "column", "i"))
  expect_equal(nrow(stab), 9)
  stab <- bc$get_samples(include_id = TRUE)
  expect_true(tibble::is_tibble(stab))
  expect_named(stab, c("row", "column", ".sample_id", "i"))
  expect_equal(nrow(stab), 9)
  stab <- bc$get_samples(include_id = TRUE, remove_empty_locations = TRUE)
  expect_true(tibble::is_tibble(stab))
  expect_named(stab, c("row", "column", ".sample_id", "i"))
  expect_equal(nrow(stab), 8)
  bc <- assign_random(bc)
  stab <- bc$get_samples(include_id = TRUE, assignment = FALSE)
  expect_true(tibble::is_tibble(stab))
  expect_named(stab, c(".sample_id", "i"))
  expect_equal(nrow(stab), 8)
  expect_equal(stab$.sample_id, seq_len(8))
})

test_that("$get_samles(as_tibble=FALSE) returns correct columns & expected number of rows", {
  bc <- BatchContainer$new(
    dimensions = c(row = 3, column = 3)
  )
  samp <- data.frame(i = 1:8)
  expect_error(bc$get_samples())
  bc$samples <- samp
  bc <- assign_in_order(bc)
  stab <- bc$get_samples(as_tibble = FALSE)
  expect_true(data.table::is.data.table(stab))
  expect_named(stab, c("row", "column", "i"))
  expect_equal(nrow(stab), 9)
  stab <- bc$get_samples(include_id = TRUE, as_tibble = FALSE)
  expect_true(data.table::is.data.table(stab))
  expect_named(stab, c("row", "column", ".sample_id", "i"))
  expect_equal(nrow(stab), 9)
  stab <- bc$get_samples(include_id = TRUE, remove_empty_locations = TRUE, as_tibble = FALSE)
  expect_true(data.table::is.data.table(stab))
  expect_named(stab, c("row", "column", ".sample_id", "i"))
  expect_equal(nrow(stab), 8)
  bc <- assign_random(bc)
  stab <- bc$get_samples(include_id = TRUE, assignment = FALSE, as_tibble = FALSE)
  expect_true(data.table::is.data.table(stab))
  expect_named(stab, c(".sample_id", "i"))
  expect_equal(nrow(stab), 8)
  expect_equal(stab$.sample_id, seq_len(8))
})
